<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;

// use App\Http\Controllers\Talenta\EmployeeController as TEmployee;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

// Demo API untuk development
Route::middleware(['throttle:10,1'])->group(function () {
    Route::get('/demo-users', [AuthController::class, 'getDemoUsers']);
});

Route::get('/healthz', function () {
    return response()->json(['status' => 'ok']);
});

// Route::prefix('talenta')->name('talenta.')->group(function () {
//     Route::get('/employees',         [TEmployee::class, 'index'])->name('employees.index');
//     Route::get('/employees/{id}',    [TEmployee::class, 'show'])->name('employees.show');
//     Route::post('/employees',        [TEmployee::class, 'store'])->name('employees.store');
//     Route::put('/employees/{id}',    [TEmployee::class, 'update'])->name('employees.update');
//     Route::delete('/employees/{id}', [TEmployee::class, 'destroy'])->name('employees.destroy');
// });
