<?php

namespace App\Http\Controllers\Hirbc;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class RoomController extends Controller
{
    /**
     * Show room category (Standard atau Suite)
     */
    public function showCategory($category)
    {
        $roomTypes = config('hirbc.room_types');
        
        if (!isset($roomTypes[$category])) {
            abort(404, 'Room category not found');
        }
        
        $categoryData = $roomTypes[$category];
        $rooms = $categoryData['rooms'];
        $categoryName = $categoryData['name'];
        
        return view('hirbc.room-category', compact('category', 'categoryName', 'rooms'));
    }

    /**
     * Show room matrix for specific room
     */
    public function showRoomMatrix($category, $room)
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        $monthlyData = [];

        foreach ($months as $month) {
            $tableName = "{$month}_hirbc";
            
            try {
                $data = DB::table($tableName)
                    ->where('Room', $room)
                    ->get();
                
                $monthlyData[$month] = $data;
            } catch (\Exception $e) {
                $monthlyData[$month] = collect([]);
            }
        }

        // Get category name
        $roomTypes = config('hirbc.room_types');
        $categoryName = $roomTypes[$category]['name'] ?? $category;

        return view('hirbc.room-matrix', compact('category', 'categoryName', 'room', 'monthlyData'));
    }
}