<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;

class CheckDataLoaded
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next, $company = 'hirbnd'): Response
    {
        // Skip check untuk route manage-data (biar bisa akses untuk load data)
        if ($request->routeIs("{$company}.manage-data") || $request->routeIs("{$company}.manage-data.refresh")) {
            return $next($request);
        }

        // Check if data loaded
        if (!$this->isDataLoaded($company)) {
            return redirect()->route("{$company}.manage-data")
                ->with('warning', 'Data belum dimuat. Silakan load data terlebih dahulu.');
        }

        return $next($request);
    }

    /**
     * Check if data has been loaded for specific company
     */
    private function isDataLoaded($company): bool
    {
        try {
            $months = ['january', 'february', 'march', 'april', 'may', 'june',
                      'july', 'august', 'september', 'october', 'november', 'december'];
            
            // Check any monthly table for the company
            foreach ($months as $month) {
                $tableName = "{$month}_{$company}";
                
                try {
                    if (DB::table($tableName)->exists()) {
                        return true;
                    }
                } catch (\Exception $e) {
                    // Table might not exist, continue checking
                    continue;
                }
            }

            // Check OOO table
            $oooTable = "ooo_{$company}";
            try {
                if (DB::table($oooTable)->exists()) {
                    return true;
                }
            } catch (\Exception $e) {
                // Table might not exist
            }

            return false;
        } catch (\Exception $e) {
            return false;
        }
    }
}