<?php

namespace App\Models\Hirbc;

use Illuminate\Database\Eloquent\Model;

class MonthlyRoom extends Model
{
    protected $fillable = [
        'Business_Unit',
        'Room',
        'Posting_Date',
        'Market_Code',
        'TRX_Code',
        'Amount_1',
        'Description'
    ];

    protected $casts = [
        'Posting_Date' => 'date',
        'Amount_1' => 'decimal:2'
    ];

    /**
     * Set table name dynamically based on month
     */
    public function setTable($month)
    {
        $this->table = strtolower($month) . '_hirbc';
        return $this;
    }

    /**
     * Get model instance for specific month
     */
    public static function forMonth($month)
    {
        $instance = new static;
        $instance->setTable($month);
        return $instance;
    }

    /**
     * Scope untuk filter by room
     */
    public function scopeForRoom($query, $room)
    {
        return $query->where('Room', $room);
    }

    /**
     * Scope untuk filter by date range
     */
    public function scopeDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('Posting_Date', [$startDate, $endDate]);
    }

    /**
     * Scope untuk filter by market code
     */
    public function scopeMarketCode($query, $marketCode)
    {
        return $query->where('Market_Code', $marketCode);
    }

    /**
     * Scope untuk filter by TRX code
     */
    public function scopeTrxCode($query, $trxCode)
    {
        return $query->where('TRX_Code', $trxCode);
    }

    /**
     * Scope untuk revenue data (Amount > 0)
     */
    public function scopeRevenue($query)
    {
        return $query->where('Amount_1', '>', 0);
    }
}