<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'company',
        'is_data_loaded',
        'last_data_load',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'last_data_load' => 'datetime',
            'is_data_loaded' => 'boolean',
        ];
    }

    public function hasLoadedData(): bool
    {
        return $this->is_data_loaded == 1;
    }

    public function markDataAsLoaded(): void
    {
        $this->update([
            'is_data_loaded' => 1,
            'last_data_load' => now(),
        ]);
    }

    public function resetDataLoadStatus(): void
    {
        $this->update([
            'is_data_loaded' => 0,
            'last_data_load' => null,
        ]);
    }

    public function getFormattedLastDataLoad(): string
    {
        if (!$this->last_data_load) {
            return 'Never';
        }

        return $this->last_data_load->format('d-m-Y H:i:s');
    }
}