<?php

return [
    /*
    |--------------------------------------------------------------------------
    | HIRBC Configuration
    |--------------------------------------------------------------------------
    | Holiday Inn Resort Bali Canggu (HIRBC)
    | Theme: Lavender (#D3D3FF)
    */

    'name' => 'Holiday Inn Resort Bali Canggu',
    'short_name' => 'HIRBC',
    'code' => 'HIRBC',
    'business_unit' => 'HIRBC',
    
    // Theme Colors - LAVENDER
    'colors' => [
        'primary' => '#D3D3FF',      // Lavender Light
        'secondary' => '#B8B8FF',    // Lavender Medium
        'dark' => '#9494E8',         // Lavender Dark
        'gradient_start' => '#D3D3FF',
        'gradient_end' => '#B8B8FF',
    ],
    
    // Room Statistics
    'total_rooms' => 139,
    'standard_rooms' => 129,
    'suite_rooms' => 10,
    
    // Room Types Configuration
    'room_types' => [
        'standard' => [
            'name' => 'Standard Rooms',
            'icon' => 'bed',
            'color' => '#D3D3FF',
            'count' => 129,
            'rooms' => [
                // KSUN - 1 King Premium with Balcony (56 rooms)
                '101', '103', '105', '106', '107', '111', '114', '116', '117', '120',
                '121', '122', '124', '125', '126', '128', '131', '133', '135', '136',
                '137', '139', '141', '142', '143', '144', '145', '147', '201', '203',
                '216', '218', '220', '224', '226', '228', '229', '235', '236', '237',
                '238', '301', '303', '314', '315', '317', '318', '320', '322', '323',
                '324', '326', '339', '340', '341', '342',
                
                // TDQN - 2 Twin Premium with Balcony (24 rooms)
                '102', '108', '110', '115', '119', '123', '127', '130', '134', '138',
                '140', '202', '215', '219', '223', '225', '230', '231', '234', '302',
                '316', '319', '321', '325',
                
                // KIDN - 1 King Premium Top Floor with Balcony (9 rooms)
                '501', '502', '505', '507', '508', '509', '511', '524', '525',
                
                // TMPN - 2 Twin Premium Top Floor with Balcony (3 rooms)
                '503', '506', '510',
                
                // KHGN - 1 King Premium Ocean View with Balcony (21 rooms)
                '205', '206', '208', '209', '210', '212', '227', '233', '305', '306',
                '308', '309', '310', '312', '328', '329', '330', '331', '334', '337',
                '338',
                
                // TVNN - 2 Twin Premium Ocean View with Balcony (8 rooms)
                '207', '211', '307', '311', '327', '332', '333', '336',
                
                // KOUN - 1 King Premium Ocean View Top Floor with Balcony (4 rooms)
                '514', '515', '522', '523',
                
                // TCPN - 2 Twin Premium Ocean View Top Floor with Balcony (4 rooms)
                '512', '517', '518', '520'
            ]
        ],
        'suite' => [
            'name' => 'Suite Rooms',
            'icon' => 'crown',
            'color' => '#B8B8FF',
            'count' => 10,
            'rooms' => [
                // KBFN - 1 Bedroom Family Suite with Bunk Beds (7 rooms)
                '109', '112', '129', '132', '146', '214', '217',
                
                // KKON - 1 Bedroom Suite Ocean View (3 rooms)
                '516', '519', '521'
            ]
        ]
    ],
    
    // Room Type Details
    'room_type_details' => [
        'KSUN' => ['name' => '1 King Premium with Balcony', 'category' => 'standard', 'count' => 56],
        'TDQN' => ['name' => '2 Twin Premium with Balcony', 'category' => 'standard', 'count' => 24],
        'KTSN' => ['name' => '1 King Standard', 'category' => 'standard', 'count' => 0],
        'TXSN' => ['name' => '2 Twin Standard', 'category' => 'standard', 'count' => 0],
        'KIDN' => ['name' => '1 King Premium Top Floor with Balcony', 'category' => 'standard', 'count' => 9],
        'TMPN' => ['name' => '2 Twin Premium Top Floor with Balcony', 'category' => 'standard', 'count' => 3],
        'KHGN' => ['name' => '1 King Premium Ocean View with Balcony', 'category' => 'standard', 'count' => 21],
        'TVNN' => ['name' => '2 Twin Premium Ocean View with Balcony', 'category' => 'standard', 'count' => 8],
        'KOUN' => ['name' => '1 King Premium Ocean View Top Floor with Balcony', 'category' => 'standard', 'count' => 4],
        'TCPN' => ['name' => '2 Twin Premium Ocean View Top Floor with Balcony', 'category' => 'standard', 'count' => 4],
        'KBFN' => ['name' => '1 Bedroom Family Suite with Bunk Beds', 'category' => 'suite', 'count' => 7],
        'KBGN' => ['name' => '1 Bedroom Family Suite with Bunk Beds', 'category' => 'suite', 'count' => 0],
        'KYON' => ['name' => '2 Bedroom Family Suite with Bunk Beds', 'category' => 'suite', 'count' => 0],
        'KKON' => ['name' => '1 Bedroom Suite Ocean View', 'category' => 'suite', 'count' => 3],
    ]
];