<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::create($month . '_hirbc', function (Blueprint $table) {
                $table->id();
                $table->string('Business_Unit', 50)->nullable();
                $table->string('Room', 50)->index();
                $table->date('Posting_Date')->index();
                $table->string('Market_Code', 100)->nullable()->index();
                $table->string('TRX_Code', 50)->nullable()->index();
                $table->decimal('Amount_1', 20, 2)->default(0);
                $table->text('Description')->nullable();
                $table->timestamps();
                
                $table->index(['Room', 'Posting_Date']);
                $table->index(['Market_Code', 'Posting_Date']);
                $table->index(['TRX_Code', 'Posting_Date']);
            });
        }
    }

    public function down(): void
    {
        $months = [
            'january', 'february', 'march', 'april', 'may', 'june',
            'july', 'august', 'september', 'october', 'november', 'december'
        ];

        foreach ($months as $month) {
            Schema::dropIfExists($month . '_hirbc');
        }
    }
};