<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ooo_hirbc', function (Blueprint $table) {
            $table->id();
            $table->string('Business_Unit', 50)->nullable();
            $table->integer('AuxiliaryIndex1')->nullable();
            $table->date('Begin_Date')->nullable();
            $table->date('Completed_On')->nullable()->index();
            $table->string('Room_No', 50)->index();
            $table->text('Repair_Remark')->nullable();
            $table->timestamps();
            
            $table->index(['Room_No', 'Completed_On']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ooo_hirbc');
    }
};