<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Room Monitoring System - Select Company</title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f8f9fa;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 40px 20px;
        }

        .container {
            max-width: 1400px;
            width: 100%;
        }

        .header {
            text-align: center;
            margin-bottom: 48px;
        }

        .header h1 {
            font-size: 48px;
            font-weight: 800;
            margin-bottom: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .header p {
            font-size: 18px;
            color: #6c757d;
        }

        .user-info {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 16px 32px;
            display: inline-flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 32px;
            color: white;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }

        .user-info i {
            font-size: 24px;
        }

        .user-info span {
            font-weight: 600;
            font-size: 16px;
        }

        .companies-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(380px, 1fr));
            gap: 32px;
            margin-bottom: 48px;
        }

        .company-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            text-decoration: none;
            color: inherit;
            border: 1px solid #e9ecef;
        }

        .company-card:hover {
            transform: translateY(-12px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
            border-color: transparent;
        }

        .company-header {
            padding: 40px;
            background: linear-gradient(135deg, var(--color-start), var(--color-end));
            color: white;
            position: relative;
            text-align: center;
            min-height: 280px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .company-header.blue {
            --color-start: #0ea5e9;
            --color-end: #0284c7;
        }

        .company-header.green {
            --color-start: #00897b;
            --color-end: #26a69a;
        }

        .company-header.lavender {
            --color-start: #D3D3FF;
            --color-end: #B8B8FF;
            color: #333;
        }

        .company-logo {
            width: 140px;
            height: 140px;
            background: white;
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 24px;
            padding: 20px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
        }

        .company-logo img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .company-name {
            font-size: 26px;
            font-weight: 700;
            margin-bottom: 8px;
            line-height: 1.2;
        }

        .company-code {
            font-size: 14px;
            opacity: 0.95;
            font-weight: 600;
            letter-spacing: 1.5px;
            background: rgba(255, 255, 255, 0.2);
            padding: 6px 16px;
            border-radius: 20px;
            display: inline-block;
        }

        .company-header.lavender .company-code {
            background: rgba(148, 148, 232, 0.3);
            color: #4A4A9F;
        }

        .company-body {
            padding: 32px;
        }

        .company-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 16px;
            margin-bottom: 24px;
        }

        .stat-item {
            text-align: center;
            padding: 20px;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 12px;
            transition: all 0.3s ease;
        }

        .stat-item:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }

        .stat-value {
            font-size: 32px;
            font-weight: 700;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 4px;
        }

        .stat-label {
            font-size: 12px;
            color: #6c757d;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-weight: 600;
        }

        .company-status {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            border-radius: 24px;
            font-size: 13px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-active {
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
            color: #155724;
        }

        .company-footer {
            padding: 24px 32px;
            background: #f8f9fa;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid #e9ecef;
        }

        .location {
            display: flex;
            align-items: center;
            gap: 8px;
            color: #6c757d;
            font-size: 14px;
            font-weight: 500;
        }

        .location i {
            color: #667eea;
        }

        .btn-access {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 12px 28px;
            border-radius: 10px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }

        .btn-access:hover {
            transform: translateX(4px);
            box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
        }

        .logout-section {
            text-align: center;
            padding: 32px 0;
        }

        .btn-logout {
            background: white;
            color: #667eea;
            padding: 14px 36px;
            border-radius: 12px;
            border: 2px solid #667eea;
            font-weight: 600;
            font-size: 15px;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .btn-logout:hover {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(102, 126, 234, 0.3);
        }

        /* Decorative Elements */
        .company-header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 200px;
            height: 200px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: translate(50%, -50%);
        }

        .company-header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 150px;
            height: 150px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: translate(-50%, 50%);
        }

        @media (max-width: 768px) {
            .header h1 {
                font-size: 32px;
            }

            .companies-grid {
                grid-template-columns: 1fr;
            }

            .company-logo {
                width: 120px;
                height: 120px;
            }

            .stat-item {
                padding: 16px;
            }

            .stat-value {
                font-size: 28px;
            }
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .company-card {
            animation: fadeInUp 0.6s ease-out backwards;
        }

        .company-card:nth-child(1) {
            animation-delay: 0.1s;
        }

        .company-card:nth-child(2) {
            animation-delay: 0.2s;
        }

        .company-card:nth-child(3) {
            animation-delay: 0.3s;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-building"></i> Room Monitoring System</h1>
            <p>Select a property to access the dashboard</p>
        </div>

        <!-- User Info -->
        <div style="text-align: center; margin-bottom: 48px;">
            <div class="user-info">
                <i class="fas fa-user-circle"></i>
                <span>Welcome, {{ Auth::user()->name }}!</span>
            </div>
        </div>

        <!-- Companies Grid -->
        <div class="companies-grid">
            <!-- HIRBND Card -->
            <a href="{{ route('hirbnd.dashboard') }}" class="company-card">
                <div class="company-header blue">
                    <div class="company-logo">
                        <img src="{{ asset('images/hin.png') }}" alt="Holiday Inn Nusa Dua Logo">
                    </div>
                    <div class="company-name">Holiday Inn Resort</div>
                    <div class="company-code">NUSA DUA (HIRBND)</div>
                </div>
                <div class="company-body">
                    <div class="company-stats">
                        <div class="stat-item">
                            <div class="stat-value">366</div>
                            <div class="stat-label">Total Rooms</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">19</div>
                            <div class="stat-label">Room Types</div>
                        </div>
                    </div>
                    <div style="text-align: center;">
                        <span class="company-status status-active">
                            <i class="fas fa-check-circle"></i> Active
                        </span>
                    </div>
                </div>
                <div class="company-footer">
                    <div class="location">
                        <i class="fas fa-map-marker-alt"></i>
                        <span>Nusa Dua, Bali</span>
                    </div>
                    <button class="btn-access">
                        Access <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </a>

            <!-- REGENT Card -->
            <a href="{{ route('regent.dashboard') }}" class="company-card">
                <div class="company-header green">
                    <div class="company-logo">
                        <img src="{{ asset('images/rbc.png') }}" alt="Regent Bali Logo">
                    </div>
                    <div class="company-name">Regent Bali</div>
                    <div class="company-code">CANGGU (REGENT)</div>
                </div>
                <div class="company-body">
                    <div class="company-stats">
                        <div class="stat-item">
                            <div class="stat-value">169</div>
                            <div class="stat-label">Total Rooms</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">5</div>
                            <div class="stat-label">Categories</div>
                        </div>
                    </div>
                    <div style="text-align: center;">
                        <span class="company-status status-active">
                            <i class="fas fa-check-circle"></i> Active
                        </span>
                    </div>
                </div>
                <div class="company-footer">
                    <div class="location">
                        <i class="fas fa-map-marker-alt"></i>
                        <span>Canggu, Bali</span>
                    </div>
                    <button class="btn-access">
                        Access <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </a>

            <!-- HIRBC Card -->
            <a href="{{ route('hirbc.dashboard') }}" class="company-card">
                <div class="company-header lavender">
                    <div class="company-logo">
                        <img src="{{ asset('images/hic.png') }}" alt="Holiday Inn Canggu Logo">
                    </div>
                    <div class="company-name">Holiday Inn Resort</div>
                    <div class="company-code">BALI CANGGU (HIRBC)</div>
                </div>
                <div class="company-body">
                    <div class="company-stats">
                        <div class="stat-item">
                            <div class="stat-value">192</div>
                            <div class="stat-label">Total Rooms</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">2</div>
                            <div class="stat-label">Categories</div>
                        </div>
                    </div>
                    <div style="text-align: center;">
                        <span class="company-status status-active">
                            <i class="fas fa-check-circle"></i> Active
                        </span>
                    </div>
                </div>
                <div class="company-footer">
                    <div class="location">
                        <i class="fas fa-map-marker-alt"></i>
                        <span>Canggu, Bali</span>
                    </div>
                    <button class="btn-access">
                        Access <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </a>
        </div>

        <!-- Logout Section -->
        <div class="logout-section">
            <form method="POST" action="{{ route('logout') }}" style="display: inline;">
                @csrf
                <button type="submit" class="btn-logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </button>
            </form>
        </div>
    </div>
</body>
</html>
