@extends('layouts.hirbnd')

@section('title', 'Dashboard')

@push('styles')
<style>
    .dashboard-header {
        background: linear-gradient(135deg, #0ea5e9, #0284c7);
        color: white;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
        box-shadow: 0 4px 12px rgba(14, 165, 233, 0.3);
    }

    .dashboard-header h1 {
        font-size: 32px;
        margin-bottom: 8px;
        font-weight: 700;
    }

    .dashboard-header p {
        font-size: 16px;
        opacity: 0.95;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 24px;
        margin-bottom: 32px;
    }

    .stat-card {
        background: white;
        padding: 24px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
    }

    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(14, 165, 233, 0.3);
    }

    .stat-card-header {
        display: flex;
        align-items: center;
        gap: 16px;
        margin-bottom: 16px;
    }

    .stat-icon {
        width: 56px;
        height: 56px;
        background: linear-gradient(135deg, #0ea5e9, #0284c7);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        color: white;
    }

    .stat-info h3 {
        font-size: 14px;
        color: #666;
        font-weight: 500;
        margin-bottom: 4px;
    }

    .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: #333;
    }

    .room-types-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 24px;
        margin-bottom: 32px;
    }

    .room-type-card {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
        text-decoration: none;
        color: inherit;
    }

    .room-type-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(14, 165, 233, 0.3);
    }

    .room-type-header {
        background: linear-gradient(135deg, #0ea5e9, #0284c7);
        padding: 24px;
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .room-type-icon {
        width: 60px;
        height: 60px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 30px;
        color: white;
    }

    .room-type-title {
        flex: 1;
    }

    .room-type-title h3 {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 4px;
        color: white;
    }

    .room-type-title p {
        font-size: 14px;
        opacity: 0.9;
        color: white;
    }

    .room-type-body {
        padding: 24px;
    }

    .room-count {
        font-size: 40px;
        font-weight: 700;
        color: #0ea5e9;
        margin-bottom: 8px;
    }

    .room-count-label {
        font-size: 14px;
        color: #666;
    }

    .quick-actions {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .quick-actions h2 {
        font-size: 20px;
        margin-bottom: 20px;
        color: #333;
    }

    .action-buttons {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
    }

    .action-btn {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 16px 20px;
        background: linear-gradient(135deg, #0ea5e9, #0284c7);
        color: white;
        text-decoration: none;
        border-radius: 10px;
        font-weight: 600;
        transition: all 0.3s;
    }

    .action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(14, 165, 233, 0.4);
    }

    .action-btn i {
        font-size: 20px;
    }
</style>
@endpush

@section('content')
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <h1><i class="fas fa-building"></i> HIRBND Dashboard</h1>
        <p>Holiday Inn Resort Bali Nusa Dua - Room Monitoring & Revenue System</p>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-door-open"></i>
                </div>
                <div class="stat-info">
                    <h3>Total Rooms</h3>
                    <div class="stat-value">366</div>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <div class="stat-info">
                    <h3>Months Loaded</h3>
                    <div class="stat-value">12/12</div>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-database"></i>
                </div>
                <div class="stat-info">
                    <h3>Room Types</h3>
                    <div class="stat-value">19</div>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="stat-info">
                    <h3>Active Reports</h3>
                    <div class="stat-value">4</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Room Types -->
    <div class="room-types-grid">
        <a href="{{ route('hirbnd.standard') }}" class="room-type-card">
            <div class="room-type-header">
                <div class="room-type-icon">
                    <i class="fas fa-bed"></i>
                </div>
                <div class="room-type-title">
                    <h3>Standard Rooms</h3>
                    <p>View all rooms</p>
                </div>
            </div>
            <div class="room-type-body">
                <div class="room-count">13</div>
                <div class="room-count-label">Room Types Available</div>
            </div>
        </a>

        <a href="{{ route('hirbnd.suite') }}" class="room-type-card">
            <div class="room-type-header">
                <div class="room-type-icon">
                    <i class="fas fa-crown"></i>
                </div>
                <div class="room-type-title">
                    <h3>Suite Rooms</h3>
                    <p>View all rooms</p>
                </div>
            </div>
            <div class="room-type-body">
                <div class="room-count">6</div>
                <div class="room-count-label">Suite Types Available</div>
            </div>
        </a>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <h2><i class="fas fa-bolt"></i> Quick Actions</h2>
        <div class="action-buttons">
            <a href="{{ route('hirbnd.manage-data') }}" class="action-btn">
                <i class="fas fa-sync-alt"></i>
                <span>Refresh Data</span>
            </a>
            <a href="{{ route('hirbnd.reports.revenue') }}" class="action-btn">
                <i class="fas fa-chart-line"></i>
                <span>Revenue Report</span>
            </a>
            <a href="{{ route('hirbnd.reports.ooo') }}" class="action-btn">
                <i class="fas fa-exclamation-triangle"></i>
                <span>OOO Report</span>
            </a>
            <a href="{{ route('hirbnd.reports.house-use') }}" class="action-btn">
                <i class="fas fa-house-user"></i>
                <span>House Use</span>
            </a>
        </div>
    </div>
@endsection
