@extends('layouts.hirbnd')

@section('title', 'Suite Rooms - HIRBND')
@section('page-title', 'Suite Rooms')

@push('styles')
<style>
    .room-types-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 24px;
    }

    .room-type-card {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
        border: 2px solid transparent;
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }

    .room-type-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #0066CC, #6f42c1);
    }

    .room-type-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 6px 20px rgba(111, 66, 193, 0.3);
        border-color: #6f42c1;
    }

    .room-type-header {
        display: flex;
        align-items: center;
        gap: 16px;
        margin-bottom: 16px;
        padding-bottom: 16px;
        border-bottom: 2px solid #f0f0f0;
    }

    .room-type-icon {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #6f42c1, #5a32a3);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        color: white;
    }

    .room-type-info {
        flex: 1;
    }

    .room-type-code {
        font-size: 20px;
        font-weight: 700;
        color: #6f42c1;
        margin-bottom: 4px;
    }

    .room-type-name {
        font-size: 14px;
        color: #6c757d;
        line-height: 1.4;
    }

    .suite-badge {
        position: absolute;
        top: 16px;
        right: 16px;
        background: linear-gradient(135deg, #ffd700, #ffed4e);
        color: #333;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .room-count {
        background: #f3e5f5;
        color: #6f42c1;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
        display: inline-block;
        margin-bottom: 16px;
    }

    .room-type-actions {
        display: flex;
        gap: 12px;
    }

    .btn-view {
        flex: 1;
        padding: 12px;
        background: linear-gradient(135deg, #6f42c1, #5a32a3);
        color: white;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .btn-view:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(111, 66, 193, 0.4);
    }

    .page-header {
        margin-bottom: 32px;
    }

    .page-header h2 {
        font-size: 28px;
        color: #333;
        margin-bottom: 8px;
    }

    .page-header p {
        font-size: 16px;
        color: #6c757d;
    }

    .stats-row {
        display: flex;
        gap: 20px;
        margin-bottom: 32px;
    }

    .stat-box {
        flex: 1;
        background: white;
        padding: 20px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .stat-box-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #6f42c1, #5a32a3);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 24px;
    }

    .stat-box-info .label {
        font-size: 13px;
        color: #6c757d;
        margin-bottom: 4px;
    }

    .stat-box-info .value {
        font-size: 24px;
        font-weight: 700;
        color: #333;
    }
</style>
@endpush

@section('content')
    <!-- Page Header -->
    <div class="page-header">
        <h2><i class="fas fa-crown"></i> Suite Room Types</h2>
        <p>View and monitor all suite room types at HIRBND</p>
    </div>

    <!-- Stats Row -->
    <div class="stats-row">
        <div class="stat-box">
            <div class="stat-box-icon">
                <i class="fas fa-crown"></i>
            </div>
            <div class="stat-box-info">
                <div class="label">Total Suite Types</div>
                <div class="value">{{ count($roomTypes) }}</div>
            </div>
        </div>

        <div class="stat-box">
            <div class="stat-box-icon">
                <i class="fas fa-star"></i>
            </div>
            <div class="stat-box-info">
                <div class="label">Premium Category</div>
                <div class="value">Suite</div>
            </div>
        </div>

        <div class="stat-box">
            <div class="stat-box-icon">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="stat-box-info">
                <div class="label">Data Source</div>
                <div class="value">BC API</div>
            </div>
        </div>
    </div>

    <!-- Room Types Grid -->
    <div class="room-types-grid">
        @foreach($roomTypes as $code => $name)
        <div class="room-type-card">
            <span class="suite-badge">
                <i class="fas fa-gem"></i> SUITE
            </span>

            <div class="room-type-header">
                <div class="room-type-icon">
                    <i class="fas fa-crown"></i>
                </div>
                <div class="room-type-info">
                    <div class="room-type-code">{{ $code }}</div>
                    <div class="room-type-name">{{ $name }}</div>
                </div>
            </div>

            <div class="room-count">
                <i class="fas fa-door-open"></i> Click to view rooms
            </div>

            <div class="room-type-actions">
                <a href="{{ route('hirbnd.suite.room-type', $code) }}" class="btn-view">
                    <i class="fas fa-eye"></i>
                    View Rooms
                </a>
            </div>
        </div>
        @endforeach
    </div>
@endsection