@extends('layouts.app')

@section('title', 'Under Maintenance')

@push('styles')
<style>
    .maintenance-container {
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
        padding: 20px;
    }

    .maintenance-card {
        background: white;
        border-radius: 16px;
        padding: 60px 40px;
        max-width: 600px;
        text-align: center;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }

    .maintenance-icon {
        font-size: 80px;
        color: #ffc107;
        margin-bottom: 24px;
    }

    .maintenance-card h1 {
        font-size: 32px;
        color: #333;
        margin-bottom: 16px;
    }

    .maintenance-card h2 {
        font-size: 24px;
        color: #0066CC;
        margin-bottom: 24px;
    }

    .maintenance-card p {
        font-size: 16px;
        color: #6c757d;
        line-height: 1.8;
        margin-bottom: 32px;
    }

    .btn-back {
        display: inline-block;
        padding: 14px 32px;
        background: #0066CC;
        color: white;
        text-decoration: none;
        border-radius: 8px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .btn-back:hover {
        background: #0052A3;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 102, 204, 0.3);
    }
</style>
@endpush

@section('content')
<div class="maintenance-container">
    <div class="maintenance-card">
        <div class="maintenance-icon">
            <i class="fas fa-wrench"></i>
        </div>
        <h1>Under Maintenance</h1>
        <h2>{{ $company }}</h2>
        <p>
            This company's monitoring system is currently under maintenance and will be available soon. 
            We are working hard to bring you the best experience.
        </p>
        <p>
            <strong>Expected Launch:</strong> Coming Soon<br>
            <strong>Status:</strong> Development in Progress
        </p>
        <a href="{{ route('dashboard') }}" class="btn-back">
            <i class="fas fa-arrow-left"></i> Back to Company Selection
        </a>
    </div>
</div>
@endsection