<?php

use App\Http\Controllers\Hirbc\DashboardController;
use App\Http\Controllers\Hirbc\RoomController;
use App\Http\Controllers\Hirbc\ManageDataController;
use App\Http\Controllers\Hirbc\ReportController;
use Illuminate\Support\Facades\Route;

// HIRBC Routes with prefix /hirbc
Route::prefix('hirbc')->name('hirbc.')->middleware('auth')->group(function () {
    
    // Dashboard (skip CheckDataLoaded middleware)
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Manage Data (skip CheckDataLoaded middleware)
    Route::get('/manage-data', [ManageDataController::class, 'index'])->name('manage-data');
    Route::post('/manage-data/refresh', [ManageDataController::class, 'refreshData'])->name('manage-data.refresh');

    // Routes yang butuh data loaded
    Route::middleware('check.data.loaded:hirbc')->group(function () {
        
        // Room Categories (Standard & Suite)
        Route::get('/rooms/{category}', [RoomController::class, 'showCategory'])
            ->where('category', 'standard|suite')
            ->name('rooms.category');
        
        // Room Matrix
        Route::get('/rooms/{category}/{room}', [RoomController::class, 'showRoomMatrix'])
            ->where('category', 'standard|suite')
            ->name('rooms.matrix');

        // Reports - Detail Room (harus sebelum routes reports utama!)
Route::prefix('reports')->name('reports.')->group(function () {
    // OOO Room Detail - BARU!
    Route::get('/ooo/room/{room}', [ReportController::class, 'oooRoomDetail'])->name('ooo.room');
    
    // Detail per room - existing
    Route::get('/house-use/room/{room}', [ReportController::class, 'houseUseRoomDetail'])->name('house-use.room');
    Route::get('/complimentary/room/{room}', [ReportController::class, 'complimentaryRoomDetail'])->name('complimentary.room');
    
    // Reports utama
    Route::get('/house-use', [ReportController::class, 'houseUse'])->name('house-use');
    Route::get('/complimentary', [ReportController::class, 'complimentary'])->name('complimentary');
    Route::get('/ooo', [ReportController::class, 'ooo'])->name('ooo');
    Route::get('/revenue', [ReportController::class, 'revenue'])->name('revenue');
});
    });
});