<?php

use App\Http\Controllers\Regent\DashboardController;
use App\Http\Controllers\Regent\RoomController;
use App\Http\Controllers\Regent\ManageDataController;
use App\Http\Controllers\Regent\ReportController;
use Illuminate\Support\Facades\Route;

// REGENT Routes with prefix /regent
Route::prefix('regent')->name('regent.')->middleware('auth')->group(function () {
    
    // Dashboard (skip CheckDataLoaded middleware)
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Manage Data (skip CheckDataLoaded middleware)
    Route::get('/manage-data', [ManageDataController::class, 'index'])->name('manage-data');
    Route::post('/manage-data/refresh', [ManageDataController::class, 'refreshData'])->name('manage-data.refresh');

    // Routes yang butuh data loaded
    Route::middleware('check.data.loaded:regent')->group(function () {
        
        // Room Categories
        Route::get('/rooms', [RoomController::class, 'index'])->name('rooms');
        
        // ✅ All Room Types (handles redirect for Suite & Corner Suite)
        Route::get('/rooms/{roomType}', [RoomController::class, 'showRoomType'])
            ->where('roomType', 'penthouse|beach_villa|padi_villa|suite|corner_suite')
            ->name('rooms.type');
        
        // ✅ Suite Submenu - Now accepts only 1 parameter
        Route::get('/rooms/suite/{submenu}', [RoomController::class, 'showSubmenu'])
            ->where('submenu', 'suite_gw_a|suite_gw_b|suite_gw_c|suite_gw_d')
            ->name('rooms.suite.submenu');
        
        // ✅ Corner Suite Submenu - Now accepts only 1 parameter
        Route::get('/rooms/corner_suite/{submenu}', [RoomController::class, 'showSubmenu'])
            ->where('submenu', 'corner_gw_c|corner_gw_d')
            ->name('rooms.corner.submenu');
        
        // ✅ Room Matrix - Direct Room Types
        Route::get('/rooms/{roomType}/{room}', [RoomController::class, 'showRoomMatrix'])
            ->where('roomType', 'penthouse|beach_villa|padi_villa')
            ->name('rooms.matrix');
        
        // ✅ Room Matrix - Suite Submenu
        Route::get('/rooms/suite/{submenu}/{room}', [RoomController::class, 'showRoomMatrix'])
            ->where('submenu', 'suite_gw_a|suite_gw_b|suite_gw_c|suite_gw_d')
            ->name('rooms.suite.matrix');
        
        // ✅ Room Matrix - Corner Suite Submenu
        Route::get('/rooms/corner_suite/{submenu}/{room}', [RoomController::class, 'showRoomMatrix'])
            ->where('submenu', 'corner_gw_c|corner_gw_d')
            ->name('rooms.corner.matrix');

        // Reports
        Route::prefix('reports')->name('reports.')->group(function () {
            Route::get('/ooo/room/{room}', [ReportController::class, 'oooRoomDetail'])->name('ooo.room');
            Route::get('/house-use/room/{room}', [ReportController::class, 'houseUseRoomDetail'])->name('house-use.room');
            Route::get('/complimentary/room/{room}', [ReportController::class, 'complimentaryRoomDetail'])->name('complimentary.room');
            
            Route::get('/house-use', [ReportController::class, 'houseUse'])->name('house-use');
            Route::get('/complimentary', [ReportController::class, 'complimentary'])->name('complimentary');
            Route::get('/ooo', [ReportController::class, 'ooo'])->name('ooo');
            Route::get('/revenue', [ReportController::class, 'revenue'])->name('revenue');
        });
    });
});