<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\DashboardController;

// Redirect root to login
Route::get('/', function () {
    return redirect()->route('login');
});

// Guest routes (Login & Register)
Route::middleware('guest')->group(function () {
    // Login
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
    
    // ✅ Register Routes
    Route::get('/register', [RegisterController::class, 'showRegister'])->name('register');
    Route::post('/register', [RegisterController::class, 'register'])->name('register.post');
});

// Authenticated routes
Route::middleware('auth')->group(function () {
    // Main dashboard - company selection
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Alias for select-company (sama seperti dashboard)
    Route::get('/select-company', [DashboardController::class, 'index'])->name('select-company');
    
    // Logout
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});

// HIRBND Routes
require __DIR__ . '/hirbnd.php';

// REGENT Routes
require __DIR__ . '/regent.php';

// HIRBC Routes
require __DIR__ . '/hirbc.php';