

<?php $__env->startSection('title', 'House Use Report - HIRBND'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* ===== STICKY HEADER WITH FILTER & STATS ===== */
    .report-sticky-header {
        position: sticky;
        top: 70px; /* Below navbar */
        z-index: 100;
        background: white;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        border-radius: 12px;
        margin-bottom: 24px;
    }

    .header-content {
        background: linear-gradient(135deg, #0066CC, #0052A3);
        color: white;
        border-radius: 12px 12px 0 0;
        padding: 24px 32px;
    }

    .header-top {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 20px;
    }

    .header-title h2 {
        font-size: 28px;
        margin-bottom: 4px;
        font-weight: 700;
    }

    .header-title p {
        font-size: 14px;
        opacity: 0.95;
    }

    .header-filter {
        display: flex;
        gap: 12px;
        align-items: center;
        background: rgba(255, 255, 255, 0.15);
        padding: 12px 16px;
        border-radius: 8px;
        backdrop-filter: blur(10px);
    }

    .header-filter label {
        font-size: 13px;
        font-weight: 600;
        margin-right: 8px;
        white-space: nowrap;
    }

    .header-filter select {
        padding: 8px 16px;
        border: 2px solid rgba(255, 255, 255, 0.3);
        border-radius: 6px;
        font-size: 13px;
        background: white;
        color: #333;
        min-width: 150px;
        font-weight: 600;
    }

    .header-filter select:focus {
        outline: none;
        border-color: white;
    }

    .btn-header {
        padding: 8px 20px;
        border: none;
        border-radius: 6px;
        font-weight: 600;
        cursor: pointer;
        font-size: 13px;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .btn-filter {
        background: white;
        color: #0066CC;
    }

    .btn-filter:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
    }

    .btn-export {
        background: #28a745;
        color: white;
    }

    .btn-export:hover {
        background: #218838;
        transform: translateY(-2px);
    }

    /* ===== STICKY STATS BAR ===== */
    .stats-bar {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 1px;
        background: #e0e0e0;
        border-radius: 0 0 12px 12px;
        overflow: hidden;
    }

    .stat-item {
        background: white;
        padding: 16px 20px;
        text-align: center;
    }

    .stat-item:first-child {
        border-radius: 0 0 0 12px;
    }

    .stat-item:last-child {
        border-radius: 0 0 12px 0;
    }

    .stat-label {
        font-size: 11px;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 6px;
        font-weight: 600;
    }

    .stat-value {
        font-size: 24px;
        font-weight: 700;
        color: #0066CC;
    }

    /* ===== MATRIX TABLE WITH STICKY HEADER ===== */
    .matrix-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    .matrix-scroll-wrapper {
        overflow: auto;
        max-height: calc(100vh - 400px);
        position: relative;
    }

    .matrix-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
        min-width: 1000px;
    }

    .matrix-table thead {
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .matrix-table th {
        background: #0066CC;
        color: white;
        padding: 14px 8px;
        text-align: center;
        font-weight: 600;
        border: 1px solid #0052A3;
        white-space: nowrap;
    }

    .matrix-table th:first-child {
        position: sticky;
        left: 0;
        z-index: 11;
        min-width: 120px;
        text-align: left;
        padding-left: 20px;
    }

    .matrix-table td {
        padding: 12px 8px;
        text-align: center;
        border: 1px solid #e0e0e0;
    }

    .matrix-table tbody tr:hover {
        background: #f8f9fa;
    }

    .matrix-table td.room-cell {
        position: sticky;
        left: 0;
        background: #f8f9fa;
        font-weight: 600;
        text-align: left;
        padding-left: 20px;
        z-index: 9;
        border-right: 2px solid #0066CC;
    }

    .matrix-table tbody tr:hover td.room-cell {
        background: #e7f3ff;
    }

    .matrix-table td.room-cell a {
        color: #0066CC;
        text-decoration: none;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .matrix-table td.room-cell a:hover {
        color: #0052A3;
    }

    .matrix-table td.house-use {
        background: #d4edda;
        color: #155724;
        font-weight: 600;
    }

    .matrix-table td.house-use i {
        color: #28a745;
        font-size: 16px;
    }

    .matrix-table td.no-data {
        background: #f8f9fa;
        color: #dee2e6;
        font-weight: 600;
    }

    /* ===== EMPTY STATE ===== */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
        color: #6c757d;
    }

    .empty-state i {
        font-size: 64px;
        margin-bottom: 20px;
        color: #dee2e6;
    }

    .empty-state h3 {
        font-size: 20px;
        margin-bottom: 8px;
        color: #495057;
    }

    .empty-state p {
        font-size: 14px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        // Process data
        if($month === 'all') {
            // All months view: Room x Month
            $rooms = [];
            $monthlyCount = [];
            
            foreach($houseUseData as $monthName => $data) {
                foreach($data as $record) {
                    $rooms[$record->Room] = true;
                    if(!isset($monthlyCount[$record->Room][$monthName])) {
                        $monthlyCount[$record->Room][$monthName] = 0;
                    }
                    $monthlyCount[$record->Room][$monthName]++;
                }
            }
            
            $rooms = array_keys($rooms);
            sort($rooms);
            
            $totalDays = 0;
            foreach($monthlyCount as $roomData) {
                $totalDays += array_sum($roomData);
            }
            
        } else {
            // Single month view: Room x Day
            $rooms = [];
            $dailyData = [];
            
            foreach($houseUseData as $record) {
                $rooms[$record->Room] = true;
                $day = (int) date('d', strtotime($record->Posting_Date));
                $dailyData[$record->Room][$day] = true;
            }
            
            $rooms = array_keys($rooms);
            sort($rooms);
            
            $totalDays = count($houseUseData);
        }
    ?>

    <!-- STICKY HEADER: Title + Filter + Stats -->
    <div class="report-sticky-header">
        <!-- Header Content with Filter -->
        <div class="header-content">
            <div class="header-top">
                <div class="header-title">
                    <h2><i class="fas fa-house-user"></i> House Use Report</h2>
                    <p>Track and monitor house use occupancy by room and date</p>
                </div>

                <form method="GET" action="<?php echo e(route('hirbnd.reports.house-use')); ?>" class="header-filter">
                    <label for="monthFilter"><i class="fas fa-calendar-alt"></i> Period:</label>
                    <select id="monthFilter" name="month" onchange="this.form.submit()">
                        <option value="all" <?php echo e($month === 'all' ? 'selected' : ''); ?>>All Months</option>
                        <option value="january" <?php echo e($month === 'january' ? 'selected' : ''); ?>>January</option>
                        <option value="february" <?php echo e($month === 'february' ? 'selected' : ''); ?>>February</option>
                        <option value="march" <?php echo e($month === 'march' ? 'selected' : ''); ?>>March</option>
                        <option value="april" <?php echo e($month === 'april' ? 'selected' : ''); ?>>April</option>
                        <option value="may" <?php echo e($month === 'may' ? 'selected' : ''); ?>>May</option>
                        <option value="june" <?php echo e($month === 'june' ? 'selected' : ''); ?>>June</option>
                        <option value="july" <?php echo e($month === 'july' ? 'selected' : ''); ?>>July</option>
                        <option value="august" <?php echo e($month === 'august' ? 'selected' : ''); ?>>August</option>
                        <option value="september" <?php echo e($month === 'september' ? 'selected' : ''); ?>>September</option>
                        <option value="october" <?php echo e($month === 'october' ? 'selected' : ''); ?>>October</option>
                        <option value="november" <?php echo e($month === 'november' ? 'selected' : ''); ?>>November</option>
                        <option value="december" <?php echo e($month === 'december' ? 'selected' : ''); ?>>December</option>
                    </select>

                    <button type="button" onclick="exportToExcel()" class="btn-header btn-export">
                        <i class="fas fa-file-excel"></i> Export
                    </button>
                </form>
            </div>
        </div>

        <!-- Stats Bar (Sticky with Header) -->
        <div class="stats-bar">
            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-calendar-check"></i> Total Days</div>
                <div class="stat-value"><?php echo e(number_format($totalDays)); ?></div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-door-open"></i> Rooms</div>
                <div class="stat-value"><?php echo e(count($rooms)); ?></div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-percentage"></i> Usage Rate</div>
                <div class="stat-value"><?php echo e(count($rooms) > 0 ? number_format(($totalDays / (count($rooms) * 31)) * 100, 1) : 0); ?>%</div>
            </div>

            <div class="stat-item">
                <div class="stat-label"><i class="fas fa-chart-line"></i> Period</div>
                <div class="stat-value" style="font-size: 18px;"><?php echo e($month === 'all' ? 'All Months' : ucfirst($month)); ?></div>
            </div>
        </div>
    </div>

    <!-- MATRIX TABLE with Sticky Header & Sticky First Column -->
    <div class="matrix-container">
        <?php if(count($rooms) === 0): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>No House Use Data Found</h3>
                <p>There are no house use records for the selected period.</p>
            </div>
        <?php else: ?>
            <div class="matrix-scroll-wrapper">
                <table class="matrix-table">
                    <thead>
                        <tr>
                            <th>Room</th>
                            <?php if($month === 'all'): ?>
                                <?php $__currentLoopData = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($monthName); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <?php for($day = 1; $day <= 31; $day++): ?>
                                    <th><?php echo e($day); ?></th>
                                <?php endfor; ?>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="room-cell">
                                    <a href="<?php echo e(route('hirbnd.reports.house-use.room', ['room' => $room, 'month' => $month])); ?>">
                                        <i class="fas fa-external-link-alt" style="font-size: 10px;"></i>
                                        Room <?php echo e($room); ?>

                                    </a>
                                </td>
                                <?php if($month === 'all'): ?>
                                    <?php $__currentLoopData = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $count = $monthlyCount[$room][$monthName] ?? 0;
                                        ?>
                                        <?php if($count > 0): ?>
                                            <td class="house-use"><?php echo e($count); ?></td>
                                        <?php else: ?>
                                            <td class="no-data">-</td>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <?php for($day = 1; $day <= 31; $day++): ?>
                                        <?php if(isset($dailyData[$room][$day])): ?>
                                            <td class="house-use"><i class="fas fa-check"></i></td>
                                        <?php else: ?>
                                            <td class="no-data">-</td>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function exportToExcel() {
        alert('Excel export feature coming soon!');
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.hirbnd', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\room-monitoring-revenue\resources\views/hirbnd/reports/house-use.blade.php ENDPATH**/ ?>