

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .dashboard-header {
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        color: #333;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 32px;
        box-shadow: 0 4px 12px rgba(211, 211, 255, 0.3);
    }

    .dashboard-header h1 {
        font-size: 32px;
        margin-bottom: 8px;
        font-weight: 700;
    }

    .dashboard-header p {
        font-size: 16px;
        opacity: 0.8;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 24px;
        margin-bottom: 32px;
    }

    .stat-card {
        background: white;
        padding: 24px;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
    }

    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(211, 211, 255, 0.4);
    }

    .stat-card-header {
        display: flex;
        align-items: center;
        gap: 16px;
        margin-bottom: 16px;
    }

    .stat-icon {
        width: 56px;
        height: 56px;
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        color: #9494E8;
    }

    .stat-info h3 {
        font-size: 14px;
        color: #666;
        font-weight: 500;
        margin-bottom: 4px;
    }

    .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: #333;
    }

    .room-types-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 24px;
        margin-bottom: 32px;
    }

    .room-type-card {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
        text-decoration: none;
        color: inherit;
    }

    .room-type-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 4px 16px rgba(211, 211, 255, 0.4);
    }

    .room-type-header {
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        padding: 24px;
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .room-type-icon {
        width: 60px;
        height: 60px;
        background: rgba(255, 255, 255, 0.5);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 30px;
        color: #9494E8;
    }

    .room-type-title {
        flex: 1;
    }

    .room-type-title h3 {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 4px;
        color: #333;
    }

    .room-type-title p {
        font-size: 14px;
        opacity: 0.8;
        color: #555;
    }

    .room-type-body {
        padding: 24px;
    }

    .room-count {
        font-size: 40px;
        font-weight: 700;
        color: #9494E8;
        margin-bottom: 8px;
    }

    .room-count-label {
        font-size: 14px;
        color: #666;
    }

    .quick-actions {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .quick-actions h2 {
        font-size: 20px;
        margin-bottom: 20px;
        color: #333;
    }

    .action-buttons {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
    }

    .action-btn {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 16px 20px;
        background: linear-gradient(135deg, #D3D3FF, #B8B8FF);
        color: #333;
        text-decoration: none;
        border-radius: 10px;
        font-weight: 600;
        transition: all 0.3s;
    }

    .action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(211, 211, 255, 0.5);
    }

    .action-btn i {
        font-size: 20px;
        color: #9494E8;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <h1><i class="fas fa-umbrella-beach"></i> HIRBC Dashboard</h1>
        <p>Holiday Inn Resort Bali Canggu - Room Monitoring & Revenue System</p>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-door-open"></i>
                </div>
                <div class="stat-info">
                    <h3>Total Rooms</h3>
                    <div class="stat-value"><?php echo e($stats['total_rooms'] ?? 0); ?></div>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <div class="stat-info">
                    <h3>Months Loaded</h3>
                    <div class="stat-value"><?php echo e($stats['months_loaded'] ?? 0); ?>/12</div>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-database"></i>
                </div>
                <div class="stat-info">
                    <h3>Total Records</h3>
                    <div class="stat-value"><?php echo e(number_format($stats['total_records'] ?? 0)); ?></div>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-header">
                <div class="stat-icon">
                    <i class="fas fa-tools"></i>
                </div>
                <div class="stat-info">
                    <h3>OOO Rooms</h3>
                    <div class="stat-value"><?php echo e($stats['ooo_records'] ?? 0); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Room Types -->
    <div class="room-types-grid">
        <?php $__currentLoopData = $roomTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $typeKey => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('hirbc.rooms.category', $typeKey)); ?>" class="room-type-card">
                <div class="room-type-header">
                    <div class="room-type-icon">
                        <i class="fas fa-<?php echo e($type['icon']); ?>"></i>
                    </div>
                    <div class="room-type-title">
                        <h3><?php echo e($type['name']); ?></h3>
                        <p>View all rooms</p>
                    </div>
                </div>
                <div class="room-type-body">
                    <div class="room-count"><?php echo e($type['count']); ?></div>
                    <div class="room-count-label">Rooms Available</div>
                </div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <h2><i class="fas fa-bolt"></i> Quick Actions</h2>
        <div class="action-buttons">
            <a href="<?php echo e(route('hirbc.manage-data')); ?>" class="action-btn">
                <i class="fas fa-sync-alt"></i>
                <span>Refresh Data</span>
            </a>
            <a href="<?php echo e(route('hirbc.reports.revenue')); ?>" class="action-btn">
                <i class="fas fa-chart-line"></i>
                <span>Revenue Report</span>
            </a>
            <a href="<?php echo e(route('hirbc.reports.ooo')); ?>" class="action-btn">
                <i class="fas fa-exclamation-triangle"></i>
                <span>OOO Report</span>
            </a>
            <a href="<?php echo e(route('hirbc.reports.house-use')); ?>" class="action-btn">
                <i class="fas fa-house-user"></i>
                <span>House Use</span>
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.hirbc', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\room-monitoring-revenue\resources\views/hirbc/dashboard.blade.php ENDPATH**/ ?>