<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
class ApprovalAction extends Model
{
    protected $fillable = [
        'approval_instance_id','step_no','actor_user_id','action','comment','acted_at',
    ];

    protected $casts = [
        'acted_at'   => 'datetime',   
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function instance(): BelongsTo { return $this->belongsTo(ApprovalInstance::class); }
    public function actor(): BelongsTo { return $this->belongsTo(User::class, 'actor_user_id'); }
}