@extends('layouts.app')
@section('title','My Form Lists')

@push('styles')
<style>
  .empty {
    display:grid; place-items:center; padding:6rem 1rem; color:#6c757d;
  }
  .card-rounded { border-radius: 1rem; }
</style>
@endpush

@section('content')
<div class="container my-4">

      <@php
        $me = \App\Models\User::firstWhere('email', session('user.email') ?? (session('user')['email'] ?? null));
      @endphp
    
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h4 class="mb-0">My Form Lists</h4>
          <small class="text-muted">All requests you created.</small>
        </div>
    
        @if($me && $me->canCreateItemRequests())
          <a href="{{ route('approvals.new') }}" class="btn btn-primary">
            <i class="fa fa-plus me-1"></i> New Item Request
          </a>
        @endif
      </div>
    
      @if(($pendingForMe->total() ?? 0) > 0)
        {{-- Approvals assigned to me --}}
        <div class="card card-rounded shadow-sm mb-4">
          <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
            <span><i class="fa fa-inbox me-2"></i>Requests awaiting my approval</span>
            <span class="badge bg-primary">{{ $pendingForMe->total() }}</span>
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th style="width:100px">#</th>
                    <th>Requester</th>
                    <th>Flow</th>
                    <th>Vendor</th> 
                    <th>Created</th>
                    <th>Step</th>
                    <th style="width:290px">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($pendingForMe as $row)
                    <tr>
                      <td>
                        <a class="text-decoration-none" href="{{ route('approvals.show', $row->id) }}">
                          <span class="badge bg-secondary">#{{ $row->id }}</span>
                        </a>
                      </td>
                      <td>
                        {{ $row->requester?->name ?? '—' }}
                        <div class="small text-muted">{{ $row->requester?->email }}</div>
                      </td>
                      <td>{{ $row->flow?->name }} @if($row->flow?->version) v{{ $row->flow->version }} @endif</td>
                      <td class="small">{{ $row->vendor_name ?? '—' }}</td>   {{-- + --}}
                      <td class="text-muted small">{{ $row->created_at?->format('Y-m-d H:i') }}</td>
                      <td>
                        <span class="badge bg-info text-dark">
                          {{ $row->current_step_no }} / {{ $stepsCount[$row->flow_template_id] ?? '—' }}
                        </span>
                      </td>
                      <td>
                        <form class="d-flex gap-2" method="POST" action="{{ route('approvals.web.approve', $row->id) }}">
                          @csrf
                          <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment (optional)">
                          <button class="btn btn-success btn-sm">
                            <i class="fa fa-thumbs-up me-1"></i> Approve
                          </button>
                        </form>
                        <form class="mt-2" method="POST" action="{{ route('approvals.web.reject', $row->id) }}">
                          @csrf
                          <div class="d-flex gap-2">
                            <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment (optional)">
                            <button class="btn btn-danger btn-sm">
                              <i class="fa fa-thumbs-down me-1"></i> Reject
                            </button>
                          </div>
                        </form>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
            <div class="p-3">
              {{ $pendingForMe->links('pagination::bootstrap-5') }}
            </div>
          </div>
        </div>
      @else
        {{-- Not an approver / nothing assigned: empty state (your screenshot behavior) --}}
        <div class="empty">
          <div class="text-center">
            <div class="display-6 mb-2"><i class="fa fa-box-open"></i></div>
            <div class="fw-semibold">No forms yet</div>
            <div class="small">Create a new request to see it here.</div>
          </div>
        </div>
      @endif
    
      {{-- (Optional) Show my own created drafts/requests below --}}
      @if(($items->total() ?? 0) > 0)
        <div class="card card-rounded shadow-sm mb-4">
          <div class="card-header bg-light fw-semibold">
            <i class="fa fa-file-alt me-2"></i>My Requests
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-sm align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th style="width:90px">#</th>
                    <th>Status</th>
                    <th>Lines</th>
                    <th>Vendor</th>               
                    <th>Posting Date</th>
                    <th>Updated</th>
                    <th>Step</th>
                    <th style="width:120px">Open</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($items as $it)
                    <tr>
                      <td><span class="badge bg-secondary">#{{ $it->id }}</span></td>
                      <td>
                        @php
                          $cls = match($it->status) {
                            'Draft' => 'bg-secondary',
                            'InReview' => 'bg-warning text-dark',
                            'Approved' => 'bg-success',
                            'Rejected' => 'bg-danger',
                            'Cancelled  '  => 'bg-dark', 
                            default => 'bg-secondary'
                          };
                        @endphp
                        <span class="badge {{ $cls }}">{{ $it->status }}</span>
                      </td>
                      <td><span class="badge bg-primary">{{ $it->lines_count }}</span></td>
                      <td class="small">{{ $it->vendor_name ?? '—' }}</td>   {{-- + --}}
                      <td class="small text-muted">{{ $it->posting_date?->format('Y-m-d') ?? '—' }}</td>
                      <td class="small text-muted">{{ $it->updated_at?->format('Y-m-d H:i') }}</td>
                      <td>
                        <span class="badge bg-info text-dark">
                          {{ $it->current_step_no }} / {{ $stepsCount[$it->flow_template_id] ?? '—' }}
                        </span>
                      </td>
                      @php $me = \App\Models\User::firstWhere('email', session('user.email') ?? session('user')['email'] ?? null); @endphp
                      <td class="text-end">
                          <div class="d-flex gap-2 justify-content-end">
                            <a href="{{ route('approvals.show', $it->id) }}" class="btn btn-outline-primary btn-sm">
                              <i class="fa fa-eye"></i> View
                            </a>
    
                            @if($it->status === 'Draft' && ($it->requester_id === optional($me)->id || optional($me)->isAdmin()))
                              <form method="POST" action="{{ route('approvals.destroy', $it->id) }}"
                                    onsubmit="return confirm('Delete this draft permanently?');">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-outline-danger btn-sm">
                                  <i class="fa fa-trash"></i>
                                  Delete
                                </button>
                              </form>
                            @endif
                          </div>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
            <div class="p-3">{{ $items->links('pagination::bootstrap-5') }}</div>
          </div>
        </div>
      @endif

</div>
@endsection
