
<?php $__env->startSection('title','My Form Lists'); ?>

<?php $__env->startPush('styles'); ?>
<style>
  .empty {
    display:grid; place-items:center; padding:6rem 1rem; color:#6c757d;
  }
  .card-rounded { border-radius: 1rem; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container my-4">

      <<?php
        $me = \App\Models\User::firstWhere('email', session('user.email') ?? (session('user')['email'] ?? null));
      ?>
    
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h4 class="mb-0">My Form Lists</h4>
          <small class="text-muted">All requests you created.</small>
        </div>
    
        <?php if($me && $me->canCreateItemRequests()): ?>
          <a href="<?php echo e(route('approvals.new')); ?>" class="btn btn-primary">
            <i class="fa fa-plus me-1"></i> New Item Request
          </a>
        <?php endif; ?>
      </div>
    
      <?php if(($pendingForMe->total() ?? 0) > 0): ?>
        
        <div class="card card-rounded shadow-sm mb-4">
          <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
            <span><i class="fa fa-inbox me-2"></i>Requests awaiting my approval</span>
            <span class="badge bg-primary"><?php echo e($pendingForMe->total()); ?></span>
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th style="width:100px">#</th>
                    <th>Requester</th>
                    <th>Flow</th>
                    <th>Vendor</th> 
                    <th>Created</th>
                    <th>Step</th>
                    <th style="width:290px">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $pendingForMe; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td>
                        <a class="text-decoration-none" href="<?php echo e(route('approvals.show', $row->id)); ?>">
                          <span class="badge bg-secondary">#<?php echo e($row->id); ?></span>
                        </a>
                      </td>
                      <td>
                        <?php echo e($row->requester?->name ?? '—'); ?>

                        <div class="small text-muted"><?php echo e($row->requester?->email); ?></div>
                      </td>
                      <td><?php echo e($row->flow?->name); ?> <?php if($row->flow?->version): ?> v<?php echo e($row->flow->version); ?> <?php endif; ?></td>
                      <td class="small"><?php echo e($row->vendor_name ?? '—'); ?></td>   
                      <td class="text-muted small"><?php echo e($row->created_at?->format('Y-m-d H:i')); ?></td>
                      <td>
                        <span class="badge bg-info text-dark">
                          <?php echo e($row->current_step_no); ?> / <?php echo e($stepsCount[$row->flow_template_id] ?? '—'); ?>

                        </span>
                      </td>
                      <td>
                        <form class="d-flex gap-2" method="POST" action="<?php echo e(route('approvals.web.approve', $row->id)); ?>">
                          <?php echo csrf_field(); ?>
                          <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment (optional)">
                          <button class="btn btn-success btn-sm">
                            <i class="fa fa-thumbs-up me-1"></i> Approve
                          </button>
                        </form>
                        <form class="mt-2" method="POST" action="<?php echo e(route('approvals.web.reject', $row->id)); ?>">
                          <?php echo csrf_field(); ?>
                          <div class="d-flex gap-2">
                            <input type="text" name="comment" class="form-control form-control-sm" placeholder="Comment (optional)">
                            <button class="btn btn-danger btn-sm">
                              <i class="fa fa-thumbs-down me-1"></i> Reject
                            </button>
                          </div>
                        </form>
                      </td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            <div class="p-3">
              <?php echo e($pendingForMe->links('pagination::bootstrap-5')); ?>

            </div>
          </div>
        </div>
      <?php else: ?>
        
        <div class="empty">
          <div class="text-center">
            <div class="display-6 mb-2"><i class="fa fa-box-open"></i></div>
            <div class="fw-semibold">No forms yet</div>
            <div class="small">Create a new request to see it here.</div>
          </div>
        </div>
      <?php endif; ?>
    
      
      <?php if(($items->total() ?? 0) > 0): ?>
        <div class="card card-rounded shadow-sm mb-4">
          <div class="card-header bg-light fw-semibold">
            <i class="fa fa-file-alt me-2"></i>My Requests
          </div>
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table table-sm align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th style="width:90px">#</th>
                    <th>Status</th>
                    <th>Lines</th>
                    <th>Vendor</th>               
                    <th>Posting Date</th>
                    <th>Updated</th>
                    <th>Step</th>
                    <th style="width:120px">Open</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><span class="badge bg-secondary">#<?php echo e($it->id); ?></span></td>
                      <td>
                        <?php
                          $cls = match($it->status) {
                            'Draft' => 'bg-secondary',
                            'InReview' => 'bg-warning text-dark',
                            'Approved' => 'bg-success',
                            'Rejected' => 'bg-danger',
                            'Cancelled  '  => 'bg-dark', 
                            default => 'bg-secondary'
                          };
                        ?>
                        <span class="badge <?php echo e($cls); ?>"><?php echo e($it->status); ?></span>
                      </td>
                      <td><span class="badge bg-primary"><?php echo e($it->lines_count); ?></span></td>
                      <td class="small"><?php echo e($it->vendor_name ?? '—'); ?></td>   
                      <td class="small text-muted"><?php echo e($it->posting_date?->format('Y-m-d') ?? '—'); ?></td>
                      <td class="small text-muted"><?php echo e($it->updated_at?->format('Y-m-d H:i')); ?></td>
                      <td>
                        <span class="badge bg-info text-dark">
                          <?php echo e($it->current_step_no); ?> / <?php echo e($stepsCount[$it->flow_template_id] ?? '—'); ?>

                        </span>
                      </td>
                      <?php $me = \App\Models\User::firstWhere('email', session('user.email') ?? session('user')['email'] ?? null); ?>
                      <td class="text-end">
                          <div class="d-flex gap-2 justify-content-end">
                            <a href="<?php echo e(route('approvals.show', $it->id)); ?>" class="btn btn-outline-primary btn-sm">
                              <i class="fa fa-eye"></i> View
                            </a>
    
                            <?php if($it->status === 'Draft' && ($it->requester_id === optional($me)->id || optional($me)->isAdmin())): ?>
                              <form method="POST" action="<?php echo e(route('approvals.destroy', $it->id)); ?>"
                                    onsubmit="return confirm('Delete this draft permanently?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-outline-danger btn-sm">
                                  <i class="fa fa-trash"></i>
                                  Delete
                                </button>
                              </form>
                            <?php endif; ?>
                          </div>
                      </td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            <div class="p-3"><?php echo e($items->links('pagination::bootstrap-5')); ?></div>
          </div>
        </div>
      <?php endif; ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/bc/resources/views/approvals/my_forms.blade.php ENDPATH**/ ?>