

<?php $__env->startPush('styles'); ?>
<style>
  .hero{background:linear-gradient(135deg,#0d6efd 0%,#20c997 100%);color:#fff;border-radius:1rem}
  .badge-status{font-weight:600}
  .card-rounded{border-radius:1rem}
  .quote-pill{border:1px solid var(--bs-border-color); border-radius:.75rem; padding:.25rem .5rem}
  .quote-selected{background:rgba(25,135,84,.1); border-color:rgba(25,135,84,.35)}
  .sig-box{min-height:100px; border:1px dashed #d0d7de; border-radius:.75rem; display:flex; align-items:center; justify-content:center; background:#fff}
  .sig-box img{max-height:90px; max-width:100%; object-fit:contain}
  @media print{
    .d-print-none{display:none!important}
    .hero{color:#000; background:#fff}
    .card{box-shadow:none!important}
  }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php use Illuminate\Support\Str; ?>
<div class="container my-4">

  <?php if(session('success')): ?>
    <div class="alert alert-success d-print-none d-flex align-items-center" role="alert">
      <i class="fa fa-check-circle me-2"></i>
      <div><?php echo e(session('success')); ?></div>
    </div>
  <?php endif; ?>

  <div class="hero p-4 mb-4 shadow-sm d-print-none">
    <div class="d-flex flex-wrap justify-content-between align-items-center gap-3">
      <div>
        <div class="d-flex align-items-center gap-3">
          <h2 class="mb-0">Request <span class="opacity-75">#<?php echo e($req->id ?? $req->id); ?></span></h2>
          <?php
            $status = $req->status;
            $statusClass = match($status) {
              'Draft' => 'bg-secondary',
              'InReview' => 'bg-warning text-dark',
              'Approved' => 'bg-success',
              'Rejected' => 'bg-danger',
              'Cancelled' => 'bg-dark',
              default => 'bg-secondary'
            };
          ?>
          <span class="badge badge-status <?php echo e($statusClass); ?>"><?php echo e($status); ?></span>
          <?php if($status === 'InReview'): ?>
            <span class="badge bg-info">Step <?php echo e($req->current_step_no); ?></span>
          <?php endif; ?>
        </div>
        <div class="mt-2 small opacity-75">
          Flow: <?php echo e(optional($req->flow)->name ?? '—'); ?>

          <?php if(optional($req->flow)->version): ?> <span class="ms-1">v<?php echo e($req->flow->version); ?></span> <?php endif; ?>
          &nbsp;&middot;&nbsp; Created: <?php echo e($req->created_at?->timezone('Asia/Singapore')->format('Y-m-d H:i') ?? '—'); ?>

        </div>
      </div>

      <div class="d-flex gap-2">
        <a href="<?php echo e(route('approvals.mine')); ?>" class="btn btn-light d-print-none">
          <i class="fa fa-inbox me-1"></i> My Forms
        </a>
        <?php
          $me = auth()->user();
          $isOwner = $me && ((int)$me->id === (int)$req->requester_id);
          $isAdmin = $me && (method_exists($me,'isAdmin') ? $me->isAdmin() : optional($me->role)->code === 'ADMIN');
        
          $canEdit = false;
          if (in_array($req->status, ['Draft','Rejected','Cancelled', 'InReview'], true)) {
            $canEdit = $isOwner || $isAdmin;
          } elseif ($req->status === 'Approved') {
            if ($isAdmin) {
              $canEdit = true;
            } else {
              $maxStep = \App\Models\ApprovalStepTemplate::where('flow_template_id', $req->flow_template_id)->max('step_no');
              if ($req->current_step_no === $maxStep) {
                  $lastApprove = optional($req->instance)->actions
                      ->where('action','Approve')
                      ->sortByDesc('acted_at')
                      ->first();
        
                  if ($lastApprove && $lastApprove->actor?->id === $me->id) {
                      $canEdit = true;
                  }
              }
            }
          }
        ?>
        <?php if($canEdit): ?>
          <a href="<?php echo e(route('approvals.edit',$req->id)); ?>" class="btn btn-outline-light d-print-none">
            <i class="fa fa-pen me-1"></i> Edit Draft
          </a>
        <?php endif; ?>
        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-light d-print-none">
          <i class="fa fa-arrow-left me-1"></i> Back
        </a>
      </div>
    </div>
  </div>

  <div class="row g-4">
    <div class="col-lg-8">

      <div class="card card-rounded shadow-sm">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
          <div class="fw-semibold"><i class="fa fa-list me-2"></i>Lines</div>
          <div class="d-flex align-items-center gap-2 d-print-none">
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="toggleAllLineDetails(true)">
              <i class="fa fa-eye me-1"></i> Open all
            </button>
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="toggleAllLineDetails(false)">
              <i class="fa fa-eye-slash me-1"></i> Collapse all
            </button>
            <span class="badge bg-primary ms-2">
              <?php echo e($req->lines->count()); ?> item<?php echo e($req->lines->count()===1?'':'s'); ?>

            </span>
          </div>
        </div>
        <div class="card-body">
          <?php if($req->lines->isEmpty()): ?>
            <div class="text-muted">No lines.</div>
          <?php else: ?>
            <div class="table-responsive">
              <table class="table align-middle">
                <thead class="table-light">
                  <tr>
                    <th style="width:60px">#</th>
                    <th>Article</th>
                    <th style="width:130px">Type</th>
                    <th style="width:110px">Unit</th>
                    <th style="width:140px">GL Account</th>
                    <th style="width:140px">Local Code</th>
                    <th>Remarks</th>
                    <th style="width:110px" class="d-print-none"></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $req->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                      $rowId = 'line-'.$l->id.'-'.$i;
                      $quotes = is_array($l->vendor_quotes) ? $l->vendor_quotes : [];
                      $selIdx = null;
                      foreach ($quotes as $qi => $q) { if (!empty($q['selected'])) { $selIdx = $qi; break; } }
                    ?>
                    <tr>
                      <td><span class="badge bg-secondary"><?php echo e($i+1); ?></span></td>
                      <td><?php echo e($l->article_name); ?></td>
                      <td>
                        <span class="badge <?php echo e($l->type==='Inventory'?'bg-primary':($l->type==='Service'?'bg-success':'bg-warning text-dark')); ?>">
                          <?php echo e($l->type); ?>

                        </span>
                      </td>
                      <td><?php echo e($l->base_unit_code); ?></td>
                      <td><?php echo e($l->gl_account_no ?: '—'); ?></td>
                      <td><?php echo e($l->article_no ?: '—'); ?></td>
                      <td class="small text-muted"><?php echo e(Str::limit($l->line_remarks, 200) ?: '—'); ?></td>
                      <td class="text-end d-print-none">
                        <button class="btn btn-outline-secondary btn-sm" data-bs-toggle="collapse" data-bs-target="#<?php echo e($rowId); ?>">
                          <i class="fa fa-eye me-1"></i> Details
                        </button>
                      </td>
                    </tr>

                    <!-- Details -->
                    <tr class="collapse bg-light" id="<?php echo e($rowId); ?>" data-line-collapse>
                      <td colspan="8">
                        <div class="row g-3 py-2">
                          <div class="col-md-4">
                            <div class="text-muted small">Inventory Posting Group</div>
                            <div><?php echo e($l->inventory_posting_group_code ?: '—'); ?></div>
                          </div>
                          <div class="col-md-4">
                            <div class="text-muted small">Gen. Prod. Posting Group</div>
                            <div><?php echo e($l->gen_prod_posting_group_code ?: '—'); ?></div>
                          </div>
                          <div class="col-md-2">
                            <div class="text-muted small">L1</div>
                            <div><?php echo e($l->l1 ?: '—'); ?></div>
                          </div>
                          <div class="col-md-2">
                            <div class="text-muted small">L2</div>
                            <div><?php echo e($l->l2 ?: '—'); ?></div>
                          </div>
                          <div class="col-12">
                            <div class="text-muted small mb-1">Vendor Quotes</div>
                            <?php if(!count($quotes)): ?>
                              <div class="text-muted">—</div>
                            <?php else: ?>
                              <div class="d-flex flex-wrap gap-2">
                                <?php $__currentLoopData = $quotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qi => $q): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <div class="quote-pill <?php echo e($selIdx === $qi ? 'quote-selected' : ''); ?>">
                                    <strong><?php echo e($q['name'] ?? '—'); ?></strong>
                                    <span class="ms-2"><?php echo e(number_format((float)($q['price'] ?? 0), 2)); ?></span>
                                    <span class="text-muted"><?php echo e($q['currency'] ?? 'IDR'); ?></span>
                                    <?php if($selIdx === $qi): ?>
                                      <span class="badge bg-success ms-2">Selected</span>
                                    <?php endif; ?>
                                  </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </div>
                            <?php endif; ?>
                          </div>
                          <!-- /Vendor quotes summary -->
                        </div>
                      </td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          <?php endif; ?>
        </div>
      </div>
      
      <h3 class="mt-5">Comments</h3>

    <div class="card mb-3">
        <div class="card-body" style="max-height: 300px; overflow-y: auto;">
            <?php $__empty_1 = true; $__currentLoopData = $req->comments()->with('user')->latest()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="mb-3 p-2 border rounded">
                    <strong><?php echo e($comment->user->name ?? 'Unknown'); ?></strong>
                    <small class="text-muted"><?php echo e($comment->created_at->diffForHumans()); ?></small>
                    <p class="mb-0"><?php echo e($comment->body); ?></p>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-muted">No comments yet.</p>
            <?php endif; ?>
        </div>
    </div>
    
    <form action="<?php echo e(route('approvals.comments.store', $req->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="input-group">
            <input type="text" name="body" class="form-control" placeholder="Write a comment..." required>
            <button class="btn btn-primary" type="submit">Send</button>
        </div>
    </form>

      <?php $actions = optional($req->instance)->actions ?? collect(); ?>
      <?php if($actions->count()): ?>
      <div class="card card-rounded shadow-sm mt-4">
        <div class="card-header bg-light fw-semibold">
          <i class="fa fa-clock-rotate-left me-2"></i>Approval History
        </div>
        <div class="card-body">
          <ul class="list-group list-group-flush">
            <?php $__currentLoopData = $actions->sortBy('acted_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php
                $ac = $act->action;
                $ic = match($ac) {
                'Submit'  => 'fa-paper-plane',
                'Approve' => 'fa-thumbs-up',
                'Reject'  => 'fa-thumbs-down',
                'Cancel'  => 'fa-ban',            
                default   => 'fa-circle-question'
              };
              $bc = match($ac) {
                'Submit'  => 'bg-secondary',
                'Approve' => 'bg-success',
                'Reject'  => 'bg-danger',
                'Cancel'  => 'bg-dark',         
                default   => 'bg-secondary'
              };
              ?>
              <li class="list-group-item d-flex justify-content-between align-items-start">
                <div class="me-3">
                  <span class="badge <?php echo e($bc); ?>"><i class="fa <?php echo e($ic); ?> me-1"></i><?php echo e($ac); ?></span>
                  <span class="ms-2"><?php echo e($act->actor?->name ?? 'User #'.$act->actor_user_id); ?></span>
                  <small class="text-muted ms-2">Step <?php echo e($act->step_no); ?></small>
                  <?php if($act->comment): ?>
                    <div class="small text-muted mt-1"><i class="fa fa-comment-dots me-1"></i><?php echo e($act->comment); ?></div>
                  <?php endif; ?>
                </div>
                <div class="text-nowrap small text-muted">
                  <?php echo e(\Illuminate\Support\Carbon::parse($act->acted_at)->timezone('Asia/Singapore')->format('Y-m-d H:i')); ?>

                </div>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <?php endif; ?>
    </div>

    <div class="col-lg-4">
      <div class="card card-rounded shadow-sm mb-4">
        <div class="card-header bg-light fw-semibold"><i class="fa fa-circle-info me-2"></i>Details</div>
        <div class="card-body">
          <dl class="row mb-0">
            <dt class="col-5">ID</dt>
            <dd class="col-7"><?php echo e($req->id ?? '—'); ?></dd>

            <dt class="col-5">Requester</dt>
            <dd class="col-7">
              <?php echo e(optional($req->requester)->name ?? '—'); ?>

              <?php if(optional($req->requester)->email): ?>
                <div class="small text-muted"><?php echo e($req->requester->email); ?></div>
              <?php endif; ?>
            </dd>

            <dt class="col-5">Company</dt>
            <dd class="col-7"><?php echo e(optional($req->company ?? null)->code ?? ($req->company_id ?? '—')); ?></dd>

            <dt class="col-5">Flow</dt>
            <dd class="col-7"><?php echo e(optional($req->flow)->name ?? '—'); ?></dd>

            <dt class="col-5">Vendor</dt>
            <dd class="col-7"><?php echo e($req->vendor_name ?: '—'); ?></dd>

            <dt class="col-5">Posting Date</dt>
            <dd class="col-7"><?php echo e($req->posting_date?->format('Y-m-d') ?? '—'); ?></dd>

            <dt class="col-5">Remarks</dt>
            <dd class="col-7"><?php echo e($req->remarks ?: '—'); ?></dd>
          </dl>
        </div>
      </div>

      <?php if(in_array($req->status, ['Draft','Rejected','Cancelled'])): ?>
        <div class="card card-rounded shadow-sm d-print-none">
          <div class="card-header bg-light fw-semibold"><i class="fa fa-paper-plane me-2"></i>Submit</div>
          <div class="card-body">
            <form method="POST" action="<?php echo e(route('approvals.web.submit', $req->id)); ?>">
              <?php echo csrf_field(); ?>
              <button class="btn btn-primary w-100"><i class="fa fa-paper-plane me-1"></i> Submit for approval</button>
            </form>
          </div>
        </div>
        <?php
          $me = auth()->user(); // cleaner than re-querying by email
        
          $isOwner = $me && ((int) $me->id === (int) $req->requester_id);
          $isAdmin = optional($me->role)->code === 'ADMIN';
        
          $canDelete = $req->status === 'Draft' && ($isOwner || $isAdmin);
        ?>

        <?php if($canDelete): ?>
          <div class="card card-rounded shadow-sm d-print-none mt-3">
            <div class="card-header bg-light fw-semibold">
              <i class="fa fa-trash me-2"></i>Delete Draft
            </div>
            <div class="card-body">
              <form method="POST" action="<?php echo e(route('approvals.destroy', $req->id)); ?>"
                    onsubmit="return confirm('Delete this draft permanently?');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button class="btn btn-outline-danger w-100">
                  <i class="fa fa-trash me-1"></i> Delete Draft
                </button>
              </form>
            </div>
          </div>
        <?php endif; ?>
      <?php elseif($req->status === 'InReview'): ?>
        <div class="card card-rounded shadow-sm d-print-none">
          <div class="card-header bg-light fw-semibold"><i class="fa fa-gavel me-2"></i>Approval Actions</div>
          <div class="card-body">
            <form class="mb-2" method="POST" action="<?php echo e(route('approvals.web.approve', $req->id)); ?>">
              <?php echo csrf_field(); ?>
              <div class="mb-2"><input type="text" class="form-control" name="comment" placeholder="Comment (optional)"></div>
              <button class="btn btn-success w-100"><i class="fa fa-thumbs-up me-1"></i> Approve</button>
            </form>
            <form method="POST" action="<?php echo e(route('approvals.web.reject', $req->id)); ?>">
              <?php echo csrf_field(); ?>
              <div class="mb-2"><input type="text" class="form-control" name="comment" placeholder="Comment (optional)"></div>
              <button class="btn btn-danger w-100"><i class="fa fa-thumbs-down me-1"></i> Reject</button>
            </form>
          </div>
          <?php
              $me = auth()->user();
            
              $status    = strtoupper(trim((string) $req->status));
              $isOwner   = $me && ((int)$me->id === (int)$req->requester_id);
              $isAdmin   = optional($me->role)->code === 'ADMIN';
            
              $canCancel = ($status === 'INREVIEW') && ($isOwner || $isAdmin);
            ?>
          <?php if($canCancel): ?>
            <div class="card card-rounded shadow-sm mt-3">
              <div class="card-header bg-light fw-semibold">
                <i class="fa fa-ban me-2"></i>Cancel Request
              </div>
              <div class="card-body">
                <form method="POST" action="<?php echo e(route('approvals.web.cancel', $req->id)); ?>"
                      onsubmit="return confirm('Cancel this request? This will stop the approval flow.');">
                  <?php echo csrf_field(); ?>
                  <div class="mb-2">
                    <input type="text" class="form-control" name="comment" placeholder="Reason (optional)">
                  </div>
                  <button class="btn btn-outline-danger w-100">
                    <i class="fa fa-ban me-1"></i> Cancel Request
                  </button>
                </form>
              </div>
            </div>
          <?php endif; ?>
        </div>
      <?php endif; ?>
      <?php
          $me = auth()->user();
        
          $status    = strtoupper(trim((string) $req->status));
          $isOwner   = $me && ((int)$me->id === (int)$req->requester_id);
          $isAdmin   = optional($me->role)->code === 'ADMIN';
        
          $canRevise = ($status === 'REJECTED') && ($isOwner || $isAdmin);
        ?>
      <?php if($canRevise): ?>
        <div class="card card-rounded shadow-sm mt-3">
          <div class="card-header bg-light fw-semibold">
            <i class="fa fa-repeat me-2"></i>Revise Request
          </div>
          <div class="card-body">
            <form method="POST" action="<?php echo e(route('approvals.web.duplicate', $req->id)); ?>">
              <?php echo csrf_field(); ?>
              <div class="form-check mb-2">
                <input class="form-check-input" type="checkbox" name="copy_attachments" id="copy_attachments" value="1">
                <label class="form-check-label" for="copy_attachments">Copy attachments</label>
              </div>
              <button class="btn btn-outline-primary w-100">
                <i class="fa fa-copy me-1"></i> Create new draft from this
              </button>
            </form>
            <div class="small text-muted mt-2">
              We’ll copy header, lines, and vendor quotes (including the selected vendor per line). Approval history is not copied.
            </div>
          </div>
        </div>
      <?php endif; ?>

      <div class="card card-rounded shadow-sm mt-4">
        <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
          <span><i class="fa fa-signature me-2"></i>Sign-off</span>
          <a href="<?php echo e(route('approvals.print', $req->id)); ?>" target="_blank"
               class="btn btn-sm btn-outline-secondary d-print-none">
              <i class="fa fa-print me-1"></i> Print
            </a>
        </div>
        <div class="card-body">
          <?php
            $steps = optional($req->flow)->steps ?? collect();
            $byStep = ($actions ?? collect())->groupBy('step_no');
          ?>
           <?php if($req->attachments->isNotEmpty()): ?>
            <div class="card card-rounded shadow-sm mb-3">
              <div class="card-header bg-light fw-semibold">
                <i class="fa fa-paperclip me-2"></i>Attachments
              </div>
              <div class="card-body p-2">
                <ul class="list-group">
                  <?php $__currentLoopData = $req->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                      <div class="text-truncate">
                        <i class="fa fa-file me-2"></i>
                        <a href="<?php echo e(route('approvals.attachments.preview', [$req->id, $att->id])); ?>" target="_blank">
                          <?php echo e($att->original_name); ?>

                        </a>
                      </div>
                      <small class="text-muted"><?php echo e(number_format($att->size/1024/1024,1)); ?> MB</small>
                    </li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
              </div>
            </div>
          <?php endif; ?>
          <?php $__empty_1 = true; $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $done      = ($byStep[$st->step_no] ?? collect())->firstWhere('action','Approve');
                $approver  = $st->approverUser ?: optional($st->approverRole);
                $sigPath   = $done?->actor?->signature_path ?? $st->approverUser?->signature_path ?? null;
            
                $base = request()->getSchemeAndHttpHost().request()->getBaseUrl();
                $imgUrl = null;
                if ($sigPath) {
                    $rel = ltrim($sigPath, '/');                                  // signatures/u-1.png
                    $rel = str_starts_with($rel, 'storage/') ? $rel : "storage/{$rel}"; // ensure 'storage/' prefix
                    if (file_exists(public_path($rel))) {
                        $imgUrl = "{$base}/public/{$rel}";
                    }
                }
            
                if (!$imgUrl) {
                    $uid = $done?->actor?->id ?? $st->approverUser?->id;
                    if ($uid) {
                        $rel = "storage/signatures/{$uid}.png";
                        if (file_exists(public_path($rel))) {
                            $imgUrl = "{$base}/public/{$rel}";
                        }
                    }
                }
              ?>
        
              <div class="mb-3">
                <div class="small text-muted">Step <?php echo e($st->step_no); ?></div>
                <div class="d-flex align-items-center gap-3">
                  <div class="sig-box flex-grow-1 text-center">
                    <?php if($imgUrl): ?>
                      <img src="<?php echo e($imgUrl); ?>?v=<?php echo e(filemtime(public_path(str_replace($base.'/public/', '', $imgUrl)))); ?>" alt="signature">
                    <?php else: ?>
                      <span class="text-muted">— signature —</span>
                    <?php endif; ?>
                  </div>
                  <div class="small">
                    <div class="fw-semibold">
                      <?php echo e($done?->actor?->name ?? ($st->approverUser?->name ?? ($st->approverRole?->code ?? ''))); ?>

                    </div>
                    <div class="text-muted">
                      <?php if($done): ?>
                        Approved at <?php echo e(\Illuminate\Support\Carbon::parse($done->acted_at)->timezone('Asia/Singapore')->format('Y-m-d H:i')); ?>

                      <?php else: ?>
                        Pending
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-muted">No steps configured.</div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
  window.toggleAllLineDetails = function(open) {
    document.querySelectorAll('[data-line-collapse]').forEach(function(el){
      if (window.bootstrap && window.bootstrap.Collapse) {
        const inst = window.bootstrap.Collapse.getOrCreateInstance(el, { toggle: false });
        open ? inst.show() : inst.hide();
      } else {
        el.classList.toggle('show', !!open);
      }
    });
  };
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/bc/resources/views/approvals/show.blade.php ENDPATH**/ ?>