<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    protected $table = 'departments';

    protected $fillable = [
        'code',
        'name',
    ];

    public $timestamps = true;

    /**
     * Scope untuk dropdown
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('code');
    }
}
