<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id', 'user_id', 'pic_id', 'item_request_id', 'item_name', 'status'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function picUser()
    {
        return $this->belongsTo(User::class, 'pic_id');
    }

    public function itemRequest()
    {
        return $this->belongsTo(ItemRequest::class);
    }

    public function attachments()
    {
        return $this->hasMany(ItemRequestAttachment::class, 'item_request_id', 'item_request_id');
    }
}
