<?php

namespace App\Support;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class CommentNotifier
{
    public static function send(array $comment): void
    {
        // Log awal: fungsi terpanggil

        // Pastikan email tujuan ada
        if (!empty($comment['notif_email'])) {
            $subject = 'New Comment on Your Request';
            $to = $comment['notif_email'];

            // Log email tujuan
            Log::info("Sending Comment email to: {$to}");

            // Build HTML body
            $body = self::buildHtmlMessage($comment);

            // Kirim email
            Mail::html($body, function ($message) use ($to, $subject) {
                $message->to($to)->subject($subject);
            });

            // Log setelah mail dikirim
            Log::info("Mail::html executed for item_request_id: {$comment['item_request_id']}");
        } else {
            Log::warning("CommentNotifier skipped sending email: target_email not set");
        }
    }

    protected static function buildTextMessage(array $comment): string
    {
        $ownerName      = $comment['requester_name'] ?? $comment['notif_email'] ?? 'Unknown';
        $commenterName  = $comment['user_name'] ?? 'Unknown';
        $commentBody    = $comment['body'] ?? '';
        $link           = route('approvals.show', $comment['item_request_id'] ?? 0);

        return <<<EOT
Hi {$ownerName},

{$commenterName} commented on your request:

"{$commentBody}"

You can view the request here: {$link}

Thanks,
Your App Team
EOT;
    }

    protected static function buildHtmlMessage(array $comment): string
    {
        $ownerName      = e($comment['requester_name'] ?? $comment['notif_email'] ?? 'Unknown');
        $commenterName  = e($comment['user_name'] ?? 'Unknown');
        $commentBody    = nl2br(e($comment['body'] ?? ''));
        $link           = route('approvals.show', $comment['item_request_id'] ?? 0);

        return <<<HTML
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.5; color: #333; }
        blockquote { border-left: 4px solid #ccc; margin: 10px 0; padding-left: 10px; color: #555; }
        .btn { display: inline-block; padding: 10px 15px; background: #4CAF50; color: white; text-decoration: none; border-radius: 5px; }
    </style>
</head>
<body>
    <h2>Hi {$ownerName},</h2>
    <p><strong>{$commenterName}</strong> commented on your request:</p>

    <blockquote>
        {$commentBody}
    </blockquote>

    <p>
        <a href="{$link}" class="btn">View Request</a>
    </p>

    <p>Thanks,<br>Your App Team</p>
</body>
</html>
HTML;
    }
}
