<?php

namespace App\Support;

class TimeFormatter
{
    public static function humanMinutes(int $minutes): string
    {
        if ($minutes <= 0) {
            return '0 menit';
        }

        $days = intdiv($minutes, 1440); // 24 * 60
        $hours = intdiv($minutes % 1440, 60);
        $mins = $minutes % 60;

        $parts = [];

        if ($days > 0) {
            $parts[] = "{$days} hari";
        }

        if ($hours > 0) {
            $parts[] = "{$hours} jam";
        }

        if ($mins > 0) {
            $parts[] = "{$mins} menit";
        }

        return implode(' ', $parts);
    }
}
