<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('item_after', function (Blueprint $table) {
            $table->id();

            $table->string('item_no', 50);
            $table->string('item_description')->nullable();
            $table->string('uom', 20)->nullable();

            $table->decimal('unit_cost', 18, 2)->default(0);
            $table->decimal('opening_balance', 18, 6)->default(0);
            $table->decimal('increase', 18, 6)->default(0);
            $table->decimal('decrease', 18, 6)->default(0);
            $table->decimal('ending_balance', 18, 6)->default(0);

            $table->decimal('blind_count', 18, 6)->default(0);
            $table->decimal('variance', 18, 6)->default(0);
            $table->decimal('total_cost', 18, 2)->default(0);

            $table->text('remarks')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_after');
    }
};
