<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('item_user_inputs', function (Blueprint $table) {

            // Tambah kolom
            $table->unsignedBigInteger('item_request_id')
                  ->after('id');

            // Foreign key constraint
            $table->foreign('item_request_id')
                  ->references('id')
                  ->on('item_requests')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('item_user_inputs', function (Blueprint $table) {

            // Drop FK dulu
            $table->dropForeign(['item_request_id']);

            // Drop kolom
            $table->dropColumn('item_request_id');
        });
    }
};
