<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('item_before', function (Blueprint $table) {
            // ➕ Tambah kolom baru
            $table->string('location', 50)->nullable()->after('id');
            $table->string('periode', 7)->nullable()->after('location'); // Format: 2025-12

            // ❌ Hapus kolom yang diminta
            $table->dropColumn([
                'increase',
                'decrease',
                'ending_balance',
                'blind_count',
                'variance',
                'total_cost'
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('item_before', function (Blueprint $table) {
            // Kembalikan kolom
            $table->decimal('increase', 15, 2)->nullable();
            $table->decimal('decrease', 15, 2)->nullable();
            $table->decimal('ending_balance', 15, 2)->nullable();
            $table->decimal('blind_count', 15, 2)->nullable();
            $table->decimal('variance', 15, 2)->nullable();
            $table->decimal('total_cost', 18, 2)->nullable();

            // Hapus kolom periode & lokasi
            $table->dropColumn(['location', 'periode']);
        });
    }
};
