<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login | Stock Opname</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;500;700;900&display=swap" rel="stylesheet">

<style>
body{
    margin:0;height:100vh;display:flex;justify-content:center;align-items:center;
    background:linear-gradient(135deg,#e8f0ff,#ffffff,#dde6ff);
    font-family:'Inter',sans-serif;
}
.card{
    width:400px;background:rgba(255,255,255,.7);backdrop-filter:blur(20px);
    padding:32px;border-radius:24px;box-shadow:0 20px 40px rgba(0,0,0,.12);
    animation:fade .6s ease;
}
@keyframes fade{from{opacity:0;transform:translateY(20px);}to{opacity:1;transform:translateY(0);}}
input{
    width:100%;padding:12px;border-radius:10px;border:1px solid #d0d7e3;margin:8px 0;
}
input:focus{border-color:#2563eb;outline:none;box-shadow:0 0 0 3px rgba(37,99,235,.2);}
.btn{padding:12px;border:none;border-radius:10px;width:100%;font-weight:700;cursor:pointer;margin-top:12px;}
.btn-primary{background:#2563eb;color:white;}
.btn-primary:hover{background:#1e4fd8;}
.btn-microsoft{
    background:white;border:1.5px solid #d1d5db;display:flex;align-items:center;
    justify-content:center;gap:10px;font-weight:600;color:#000;
}
.btn-microsoft:hover{background:#f3f4f6;}
h2{text-align:center;font-size:1.8rem;font-weight:900;margin-bottom:20px;color:#1e293b;}
a{color:#2563eb;font-weight:600;text-decoration:none;}
a:hover{text-decoration:underline;}
.error{color:#b91c1c;font-size:.9rem;margin-top:6px;}
</style>
</head>

<body>
<div class="card">

    <h2>Login</h2>

    @if($errors->any())
        <div class="error">{{ $errors->first() }}</div>
    @endif

    <form action="{{ route('login.custom') }}" method="POST">
        @csrf
        <input type="email" name="email" placeholder="Email" required value="{{ old('email') }}">
        <input type="password" name="password" placeholder="Password" required>

        <button class="btn btn-primary">Masuk</button>
    </form>

    <button class="btn btn-microsoft" onclick="window.location='{{ route('login.mbc') }}'">
        <img src="https://upload.wikimedia.org/wikipedia/commons/4/44/Microsoft_logo.svg" width="18">
        Login dengan Microsoft
    </button>

    <p style="text-align:center;margin-top:14px;font-size:.9rem;color:#6b7280;">
        Belum punya akun? <a href="{{ route('register') }}">Daftar</a>
    </p>

</div>
</body>
</html>
