@extends('layouts.app')

@section('content')
<div class="container mt-4">
  <h4>📜 Activity Logs</h4>

  <table class="table table-striped table-hover table-sm align-middle">
    <thead class="table-light">
      <tr>
        <th>User</th>
        <th>Method</th>
        <th>Changes</th>
        <th>Time</th>
      </tr>
    </thead>
    <tbody>
      @forelse($logs as $log)
        <tr>
          <td>{{ $log->user_name }}</td>
          <td>
            <span class="badge 
              @if($log->method === 'POST') bg-success
              @elseif(in_array($log->method, ['PUT', 'PATCH'])) bg-warning text-dark
              @elseif($log->method === 'DELETE') bg-danger
              @else bg-secondary
              @endif">
              {{ $log->method }}
            </span>
          </td>
          <td style="white-space: pre-line;">
            {{ $log->changes ?? '-' }}
          </td>
          <td>{{ $log->created_at->diffForHumans() }}</td>
        </tr>
      @empty
        <tr>
          <td colspan="4" class="text-center text-muted py-3">Tidak ada log aktivitas.</td>
        </tr>
      @endforelse
    </tbody>
  </table>

  <div class="mt-3">
    {{ $logs->links('pagination::bootstrap-5') }}
  </div>
</div>
@endsection
