
<?php $__env->startSection('title', 'Print — Request #' . $req->id); ?>

<?php $__env->startPush('styles'); ?>
    <?php $__env->startPush('styles'); ?>
        <style>
            /* Fit full width of A4 landscape */
            @page {
                size: A4 landscape;
                margin: 8mm;
            }

            /* smaller margin gives more width */
            @media print {
                body {
                    -webkit-print-color-adjust: exact;
                    print-color-adjust: exact;
                }
            }

            html,
            body {
                width: 100%;
                max-width: 100%
            }

            body {
                font-family: Tahoma, Arial, sans-serif;
                color: #002b2b;
            }

            .sheet-title {
                text-align: center;
                font-size: 22px;
                font-weight: 700;
                letter-spacing: .5px;
                margin: 0 0 8px;
            }

            .header-row {
                display: flex;
                align-items: flex-start;
                justify-content: space-between;
                margin: 0 0 6px;
                padding: 0 2mm;
            }

            .vendor-name {
                font-size: 12px;
                font-weight: 600;
            }

            .logos {
                display: flex;
                gap: 8px;
                align-items: center;
            }

            .logos img {
                height: 38px;
            }

            table.grid {
                width: 100%;
                border-collapse: collapse;
                table-layout: fixed;
            }

            table.grid th,
            table.grid td {
                border: 1px solid #3b5c5c;
                padding: 6px 6px;
                font-size: 12px;
                vertical-align: middle;
                word-wrap: break-word;
            }

            thead.primary th {
                background: #0c3c3d;
                color: #fff;
                font-weight: 700;
                text-align: center;
            }

            thead.secondary th {
                background: #e7f1ee;
                color: #002b2b;
                font-weight: 700;
                text-align: center;
            }

            .cmp-head,
            .coa-head {
                background: #0c3c3d;
                color: #fff;
            }

            .chosen-vendor {
                color: #c21f2f;
                font-weight: 700;
            }

            .muted {
                color: #6b7a7a;
            }

            .right {
                text-align: right;
            }

            .center {
                text-align: center;
            }

            .sig-wrap {
                margin-top: 12px;
                padding: 0 2mm;
            }

            .sig-grid {
                width: 100%;
                border-collapse: collapse;
                table-layout: fixed;
            }

            .sig-grid td {
                border: 0;
                vertical-align: top;
                padding: 8px;
            }

            .sig-box {
                height: 90px;
                border: 1px dashed #9cb0b0;
                border-radius: 10px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: #fff;
            }

            .sig-box img {
                max-height: 80px;
                max-width: 100%;
                object-fit: contain;
            }

            .sig-title {
                font-weight: 600;
                margin-top: 6px;
            }

            .sig-role {
                font-size: 12px;
                color: #6b7a7a;
            }

            .legend {
                margin-top: 8px;
                font-size: 10px;
                color: #6b7a7a;
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startSection('content'); ?>
        <script>
            const req = <?php echo json_encode($vendor, 15, 512) ?>;
            console.log(req);
        </script>
        <?php if($req->flow_template_id === 6): ?>
            <div class="container-fluid my-2">
                <h2 class="sheet-title">NEW VENDOR REQUEST FORM</h2>

                <div class="header-row">
                    <div class="header-row d-flex  gap-4 flex-wrap">
                        <!-- Vendor Info -->
                        <div class="vendor-info flex-grow-1  d-flex flex-column gap-2" style="margin-right: 20px">
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">VENDOR NAME :</span>
                                <span class="chosen-vendor"><?php echo e($vendor->vendor_name ?: $vendorHeader[0] ?? '—'); ?></span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">VENDOR ADDRESS :</span>
                                <span class="chosen-vendor"><?php echo e($vendor->address ?: $vendorHeader[1] ?? '—'); ?></span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">NPWP :</span>
                                <span class="chosen-vendor"><?php echo e($vendor->npwp ?: $vendorHeader[2] ?? '—'); ?></span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">PHONE :</span>
                                <span class="chosen-vendor"><?php echo e($vendor->phone ?: $vendorHeader[3] ?? '—'); ?></span>
                            </div>
                        </div>

                        <!-- Bank Info -->
                        <div class="vendor-info flex-grow-1 d-flex flex-column gap-2">
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">BANK :</span>
                                <span class="chosen-vendor"><?php echo e($vendor->bank_name ?: $vendorHeader[4] ?? '—'); ?></span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">ACCOUNT HOLDER :</span>
                                <span class="chosen-vendor"><?php echo e($vendor->account_holder ?: $vendorHeader[5] ?? '—'); ?></span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">ACCOUNT NUMBER :</span>
                                <span class="chosen-vendor"><?php echo e($vendor->account_number ?: $vendorHeader[6] ?? '—'); ?></span>
                            </div>
                        </div>
                    </div>


                    <?php $base = request()->getSchemeAndHttpHost().request()->getBaseUrl(); ?>
                    <div class="logos">
                        <img src="<?php echo e($base); ?>/public/storage/images/logo_ci.png" alt="CI">
                        <img src="<?php echo e($base); ?>/public/storage/images/logo_regent.png" alt="Regent">
                        <img src="<?php echo e($base); ?>/public/storage/images/logo_hic.png" alt="HIC">
                    </div>
                </div>

                <table class="grid">
                    <colgroup>
                        <col style="width:18%"> 
                        <col style="width:7%"> 
                        <col style="width:8%"> 
                        <col style="width:8%"> 
                        <col style="width:8%"> 
                        <col style="width:8%"> 
                        <col style="width:16%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                    </colgroup>
                    <thead class="primary">
                        <tr>
                            <th rowspan="2">Article Name</th>
                            <th rowspan="2">Base of Unit</th>
                            <th rowspan="2">Type</th>
                            <th class="cmp-head" colspan="3">Comparison Price</th>
                            <th rowspan="2">Remarks</th>
                            <th class="coa-head" colspan="6">COA (HOTEL FINANCE ONLY)</th>
                        </tr>
                        <tr>
                            <th>Chosen Vendor</th>
                            <th>Vendor 2</th>
                            <th>Vendor 3</th>
                            <th>Inventory Posting Group</th>
                            <th>Gen. Prod. Posting Group</th>
                            <th>Account Code</th>
                            <th>L1</th>
                            <th>L2</th>
                            <th>Article No.</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                            $padTo = max(10, $req->lines->count()); // pad to 10 rows for a full page look
                        ?>

                        <?php $__currentLoopData = $req->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $quotes = collect($l->vendor_quotes ?? []);
                                $sel = $quotes->firstWhere('selected', true) ?? $quotes->first();
                                $others = $quotes
                                    ->filter(function ($q) use ($sel) {
                                        return ($q['name'] ?? null) !== ($sel['name'] ?? null);
                                    })
                                    ->values();
                                $q2 = $others->get(0);
                                $q3 = $others->get(1);

                                // simple helpers
                                $fmt = function ($q) {
                                    if (!$q) {
                                        return '—';
                                    }
                                    $ccy = $q['currency'] ?? 'IDR';
                                    $p = is_numeric($q['price'] ?? null)
                                        ? number_format((float) $q['price'], floor($q['price']) == $q['price'] ? 0 : 2)
                                        : '—';
                                    return "{$ccy} {$p}";
                                };
                            ?>
                            <tr>
                                <td><?php echo e($l->article_name); ?></td>
                                <td class="center"><?php echo e($l->base_unit_code); ?></td>
                                <td class="center"><?php echo e($l->type); ?></td>

                                <td class="center">
                                    <div class="chosen-vendor"><?php echo e($sel['name'] ?? '—'); ?></div>
                                    <div class="muted"><?php echo e($fmt($sel)); ?></div>
                                </td>
                                <td class="center">
                                    <div><?php echo e($q2['name'] ?? '—'); ?></div>
                                    <div class="muted"><?php echo e($fmt($q2)); ?></div>
                                </td>
                                <td class="center">
                                    <div><?php echo e($q3['name'] ?? '—'); ?></div>
                                    <div class="muted"><?php echo e($fmt($q3)); ?></div>
                                </td>

                                <td><?php echo e($l->line_remarks); ?></td>
                                <td class="center"><?php echo e($l->inventory_posting_group_code ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->gen_prod_posting_group_code ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->gl_account_no ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->l1 ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->l2 ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->article_no ?: '—'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php for($i = $req->lines->count(); $i < $padTo; $i++): ?>
                            <tr>
                                <td>&nbsp;</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>

                
                <div class="sig-wrap">
                    <?php
                        $base = request()->getSchemeAndHttpHost() . request()->getBaseUrl();

                        $sigUrl = function (?int $userId) use ($base) {
                            if (!$userId) {
                                return null;
                            }
                            $rel = "storage/signatures/{$userId}.png";
                            $fs = public_path($rel);
                            return file_exists($fs) ? "{$base}/public/{$rel}" : null;
                        };

                        $preparedId = $req->requester?->id;
                        $preparedUrl = $sigUrl($req->requester?->id);

                        $acts = optional($req->instance)->actions ?? collect();

                        $approveActs = $acts->where('action', 'Approve')->sortBy('acted_at')->values();

                        $uniqueApprovers = collect();
                        $seenActorIds = collect();

                        foreach ($approveActs as $act) {
                            $actorId = $act->actor?->id;
                            if (!$actorId) {
                                continue;
                            }
                            if ($actorId === $preparedId) {
                                continue;
                            }
                            if ($seenActorIds->contains($actorId)) {
                                continue;
                            }
                            $seenActorIds->push($actorId);
                            $uniqueApprovers->push($act);
                            if ($uniqueApprovers->count() >= 3) {
                                break;
                            }
                        }

                        $approver1 = $uniqueApprovers->get(0);
                        $approver2 = $uniqueApprovers->get(1);
                        $approver3 = $uniqueApprovers->get(2);

                        $url1 = $sigUrl($approver1?->actor?->id);
                        $url2 = $sigUrl($approver2?->actor?->id);
                        $url3 = $sigUrl($approver3?->actor?->id);
                    ?>
                    <table class="sig-grid">
                        <tr>
                            
                            <td>
                                <div class="sig-box">
                                    <?php if($preparedUrl): ?>
                                        <img src="<?php echo e($preparedUrl); ?>" alt="signature">
                                    <?php else: ?>
                                        <span class="muted">— signature —</span>
                                    <?php endif; ?>
                                </div>
                                <div class="sig-title">Prepared by,</div>
                                <div><?php echo e($req->requester?->name ?? '—'); ?></div>
                                <div class="sig-role">Purchasing / Requester</div>
                            </td>

                            
                            <td>
                                <div class="sig-box">
                                    <?php if($url1): ?>
                                        <img src="<?php echo e($url1); ?>" alt="signature">
                                    <?php else: ?>
                                        <span class="muted">— signature —</span>
                                    <?php endif; ?>
                                </div>
                                <div class="sig-title">Checked By,</div>
                                <div><?php echo e($approver1?->actor?->name ?? '—'); ?></div>
                                <div class="sig-role">Manager Operational</div>
                            </td>

                            
                            <td>
                                <div class="sig-box">
                                    <?php if($url2): ?>
                                        <img src="<?php echo e($url2); ?>" alt="signature">
                                    <?php else: ?>
                                        <span class="muted">— signature —</span>
                                    <?php endif; ?>
                                </div>
                                <div class="sig-title">Approved By,</div>
                                <div><?php echo e($approver2?->actor?->name ?? '—'); ?></div>
                                <div class="sig-role">Costing Team</div>
                            </td>

                            
                            <td>
                                <div class="sig-box">
                                    <?php if($url3): ?>
                                        <img src="<?php echo e($url3); ?>" alt="signature">
                                    <?php else: ?>
                                        <span class="muted">— signature —</span>
                                    <?php endif; ?>
                                </div>
                                <div class="sig-title">Created By,</div>
                                <div><?php echo e($approver3?->actor?->name ?? '—'); ?></div>
                                <div class="sig-role">Owning Company</div>
                            </td>
                        </tr>
                    </table>

                    <div class="legend">
                        Submit with supporting document (Invoices).<br>
                    </div>
                </div>

            </div>
            <?php if(request('autoprint')): ?>
                <?php $__env->startPush('scripts'); ?>
                    <script>
                        window.print()
                    </script>
                <?php $__env->stopPush(); ?>
            <?php endif; ?>
        <?php else: ?>
            <div class="container-fluid my-2">
                <h2 class="sheet-title">NEW ITEM REQUEST FORM</h2>

                <div class="header-row">
                    <div class="vendor-name">
                        VENDOR NAME : <span class="chosen-vendor">
                            <?php echo e($req->vendor_name ?: $vendorHeader[0] ?? '—'); ?>

                        </span>
                    </div>
                    <?php $base = request()->getSchemeAndHttpHost().request()->getBaseUrl(); ?>
                    <div class="logos">
                        <img src="<?php echo e($base); ?>/public/storage/images/logo_ci.png" alt="CI">
                        <img src="<?php echo e($base); ?>/public/storage/images/logo_regent.png" alt="Regent">
                        <img src="<?php echo e($base); ?>/public/storage/images/logo_hic.png" alt="HIC">
                    </div>
                </div>

                <table class="grid">
                    <colgroup>
                        <col style="width:18%"> 
                        <col style="width:7%"> 
                        <col style="width:8%"> 
                        <col style="width:8%"> 
                        <col style="width:8%"> 
                        <col style="width:8%"> 
                        <col style="width:16%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                        <col style="width:4.5%"> 
                    </colgroup>
                    <thead class="primary">
                        <tr>
                            <th rowspan="2">Article Name</th>
                            <th rowspan="2">Base of Unit</th>
                            <th rowspan="2">Type</th>
                            <th class="cmp-head" colspan="3">Comparison Price</th>
                            <th rowspan="2">Remarks</th>
                            <th class="coa-head" colspan="6">COA (HOTEL FINANCE ONLY)</th>
                        </tr>
                        <tr>
                            <th>Chosen Vendor</th>
                            <th>Vendor 2</th>
                            <th>Vendor 3</th>
                            <th>Inventory Posting Group</th>
                            <th>Gen. Prod. Posting Group</th>
                            <th>Account Code</th>
                            <th>L1</th>
                            <th>L2</th>
                            <th>Article No.</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                            $padTo = max(10, $req->lines->count()); // pad to 10 rows for a full page look
                        ?>

                        <?php $__currentLoopData = $req->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $quotes = collect($l->vendor_quotes ?? []);
                                $sel = $quotes->firstWhere('selected', true) ?? $quotes->first();
                                $others = $quotes
                                    ->filter(function ($q) use ($sel) {
                                        return ($q['name'] ?? null) !== ($sel['name'] ?? null);
                                    })
                                    ->values();
                                $q2 = $others->get(0);
                                $q3 = $others->get(1);

                                // simple helpers
                                $fmt = function ($q) {
                                    if (!$q) {
                                        return '—';
                                    }
                                    $ccy = $q['currency'] ?? 'IDR';
                                    $p = is_numeric($q['price'] ?? null) ? number_format((float) $q['price'], 2) : '—';
                                    return "{$ccy} {$p}";
                                };
                            ?>
                            <tr>
                                <td><?php echo e($l->article_name); ?></td>
                                <td class="center"><?php echo e($l->base_unit_code); ?></td>
                                <td class="center"><?php echo e($l->type); ?></td>

                                <td class="center">
                                    <div class="chosen-vendor"><?php echo e($sel['name'] ?? '—'); ?></div>
                                    <div class="muted"><?php echo e($fmt($sel)); ?></div>
                                </td>
                                <td class="center">
                                    <div><?php echo e($q2['name'] ?? '—'); ?></div>
                                    <div class="muted"><?php echo e($fmt($q2)); ?></div>
                                </td>
                                <td class="center">
                                    <div><?php echo e($q3['name'] ?? '—'); ?></div>
                                    <div class="muted"><?php echo e($fmt($q3)); ?></div>
                                </td>

                                <td><?php echo e($l->line_remarks); ?></td>
                                <td class="center"><?php echo e($l->inventory_posting_group_code ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->gen_prod_posting_group_code ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->gl_account_no ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->l1 ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->l2 ?: '—'); ?></td>
                                <td class="center"><?php echo e($l->article_no ?: '—'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php for($i = $req->lines->count(); $i < $padTo; $i++): ?>
                            <tr>
                                <td>&nbsp;</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>

                
                <div class="sig-wrap">
                    <?php
                        $base = request()->getSchemeAndHttpHost() . request()->getBaseUrl();

                        $sigUrl = function (?int $userId) use ($base) {
                            if (!$userId) {
                                return null;
                            }
                            $rel = "storage/signatures/{$userId}.png";
                            $fs = public_path($rel);
                            return file_exists($fs) ? "{$base}/{$rel}" : null;
                        };

                        $preparedId = $req->requester?->id;
                        $preparedUrl = $sigUrl($preparedId);

                        $acts = optional($req->instance)->actions ?? collect();

                        // ===================================================================
                        // 1. Filter hanya APPROVE
                        // ===================================================================
                        $approveAll = $acts->where('action', 'Approve');

                        // ===================================================================
                        // 2. TEMUKAN SIKLUS TERBARU
                        //    yaitu step_no = 1 dengan created_at paling baru
                        // ===================================================================
                        $latestStep1 = $approveAll->where('step_no', 1)->sortByDesc('created_at')->first();

                        // Jika ada step 1 baru → ambil hanya approval setelah itu (CYCLE TERBARU)
                        if ($latestStep1) {
                            $approveActs = $approveAll
                                ->filter(fn($a) => $a->created_at >= $latestStep1->created_at)
                                ->sortBy('acted_at')
                                ->values();
                        } else {
                            // fallback kalau belum ada step 1
                            $approveActs = $approveAll->sortBy('acted_at')->values();
                        }

                        // ===================================================================
                        // 3. UNIQUE APPROVER DARI CYCLE TERBARU
                        // ===================================================================
                        $uniqueApprovers = collect();
                        $usedIds = [];

                        foreach ($approveActs as $act) {
                            $uid = $act->actor?->id;

                            if (!$uid) {
                                continue;
                            }
                            if ($uid === $preparedId) {
                                continue;
                            }
                            if (in_array($uid, $usedIds)) {
                                continue;
                            }

                            $usedIds[] = $uid;
                            $uniqueApprovers->push($act);
                        }

                        // ===================================================================
                        // 4. DATA TEMPLATE STEP (dari controller)
                        // ===================================================================
                        // $approverSlots
                        // $totalApproversNeeded

                    ?>


                    <div class="sig-container">

                        
                        <div>
                            <div class="sig-box">
                                <?php if($preparedUrl): ?>
                                    <img src="<?php echo e($preparedUrl); ?>">
                                <?php else: ?>
                                    <span class="muted">— signature —</span>
                                <?php endif; ?>
                            </div>
                            <div class="sig-title">Prepared By,</div>
                            <div><?php echo e($req->requester?->name ?? '—'); ?></div>
                            <div class="sig-role">Purchasing / Requester</div>
                        </div>


                        
                        <?php
                            // Approver yang sudah menandatangani
                            $filled = $uniqueApprovers->values();
                        ?>

                        <?php $__currentLoopData = $approverSlots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                // ambil data approve sesuai urutan template index
                                $act = $filled[$index] ?? null;

                                // tanda tangan aktor
                                $url = $act ? $sigUrl($act->actor?->id) : null;

                                // jika sudah approve → pakai nama actor
                                // jika belum approve → tampilkan nama dari template
                                $name = $act ? $act->actor?->name ?? '—' : $slot->approverUser?->name ?? '—';
                            ?>

                            <div>
                                <div class="sig-box">
                                    <?php if($url): ?>
                                        <img src="<?php echo e($url); ?>">
                                    <?php else: ?>
                                        <span class="muted">— signature —</span>
                                    <?php endif; ?>
                                </div>

                                <div class="sig-title"><?php echo e($name); ?></div>
                                <div class="sig-role">Approved By</div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>





                    <div class="legend">
                        Submit with supporting document (Invoices).<br>
                    </div>
                </div>

            </div>
            <style>
                .sig-container {
                    display: grid;
                    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
                    gap: 24px;
                    width: 100%;
                    margin-top: 32px;
                }

                .sig-box {
                    width: 100%;
                    height: 80px;
                    border-bottom: 1px solid #555;
                    display: flex;
                    justify-content: center;
                    align-items: flex-end;
                    padding-bottom: 6px;
                }

                .sig-box img {
                    max-height: 70px;
                    max-width: 100%;
                    object-fit: contain;
                }

                .sig-title {
                    margin-top: 6px;
                    font-weight: 600;
                }

                .sig-role {
                    font-size: 12px;
                    color: #777;
                }

                .muted {
                    color: #aaa;
                    font-size: 12px;
                }
            </style>

            <?php if(request('autoprint')): ?>
                <?php $__env->startPush('scripts'); ?>
                    <script>
                        window.print()
                    </script>
                <?php $__env->stopPush(); ?>
            <?php endif; ?>

        <?php endif; ?>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.print', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Lenovo\OneDrive\Documents\Kerjaan\stockopname\resources\views/approvals/print.blade.php ENDPATH**/ ?>