
<?php $__env->startSection('title', 'My Approvals'); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .card-approval {
            border: 1px solid var(--bs-border-color);
            border-left: .45rem solid var(--bs-secondary);
            border-radius: 1rem;
            transition: transform .12s ease, box-shadow .12s ease, border-color .12s ease;
        }

        .card-approval:hover {
            transform: translateY(-2px);
            box-shadow: 0 .75rem 1.5rem rgba(0, 0, 0, .06);
        }

        .card-approval[data-tone="success"] {
            border-left-color: var(--bs-success);
        }

        .card-approval[data-tone="warning"] {
            border-left-color: var(--bs-warning);
        }

        .card-approval[data-tone="danger"] {
            border-left-color: var(--bs-danger);
        }

        .card-approval[data-tone="primary"] {
            border-left-color: var(--bs-primary);
        }

        .card-approval[data-tone="secondary"] {
            border-left-color: var(--bs-secondary);
        }

        .badge-soft {
            border: 1px solid transparent;
        }

        .badge-soft-success {
            background: rgba(25, 135, 84, .12);
            color: #198754;
            border-color: rgba(25, 135, 84, .25);
        }

        .badge-soft-warning {
            background: rgba(255, 193, 7, .18);
            color: #664d03;
            border-color: rgba(255, 193, 7, .35);
        }

        .badge-soft-danger {
            background: rgba(220, 53, 69, .12);
            color: #dc3545;
            border-color: rgba(220, 53, 69, .25);
        }

        .badge-soft-primary {
            background: rgba(13, 110, 253, .12);
            color: #0d6efd;
            border-color: rgba(13, 110, 253, .25);
        }

        .badge-soft-secondary {
            background: rgba(108, 117, 125, .12);
            color: #6c757d;
            border-color: rgba(108, 117, 125, .25);
        }

        .icon-circle {
            width: 42px;
            height: 42px;
            display: grid;
            place-items: center;
            border-radius: 999px;
            background: var(--bs-light);
        }

        .line-clamp-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container my-4">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h1 class="h4 mb-0">My Approvals</h1>
                <small class="text-body-secondary">Review and open approval requests assigned to you.</small>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fa fa-check-circle me-1"></i> <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        
            <?php
                $status = strtolower((string) $req->status);
                $tone = 'secondary';
                $badge = 'badge-soft-secondary';
                if (in_array($status, ['approved', 'approve'])) {
                    $tone = 'success';
                    $badge = 'badge-soft-success';
                } elseif (in_array($status, ['pending', 'waiting', 'awaiting'])) {
                    $tone = 'warning';
                    $badge = 'badge-soft-warning';
                } elseif (in_array($status, ['rejected', 'reject'])) {
                    $tone = 'danger';
                    $badge = 'badge-soft-danger';
                } elseif (in_array($status, ['in progress', 'processing', 'open'])) {
                    $tone = 'primary';
                    $badge = 'badge-soft-primary';
                }
            ?>

            <div class="card card-approval shadow-sm mb-3" data-tone="<?php echo e($tone); ?>">
                <div class="card-body" style="cursor: pointer;"
                    onclick="window.location='<?php echo e(route('approvals.show', $req->id)); ?>'">
                    <div class="d-flex gap-3">
                        <div class="icon-circle">
                            <i class="fa fa-file-signature"></i>
                        </div>

                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between flex-wrap gap-2">
                                <div class="d-flex align-items-start gap-1">
                                    <h5 class="mb-0">#<?php echo e($req->id); ?></h5>
                                    <div class="d-flex flex-column flex-wrap gap-2">
                                        <div class="d-flex align-items-center gap-1">
                                            <span class="badge <?php echo e($badge); ?> rounded-pill px-2 py-1 text-uppercase"
                                                style="width: fit-content;">
                                                <?php echo e($req->status); ?>

                                            </span>
                                            <span class="badge-soft-primary rounded-pill px-2"
                                                style="width: fit-content; font-size:14px">
                                                <?php echo e($req->requester->name); ?>

                                            </span>
                                        </div>

                                        <div class="d-flex align-items-center gap-1">
                                            <span class="badge <?php echo e($badge); ?> rounded-pill px-2 py-1 text-uppercase"
                                                style="width: fit-content;">
                                                <?php echo e($req->flow->name); ?>

                                            </span>
                                            <span class="badge-soft-warning rounded-pill px-2" style="width: fit-content;">
                                                <?php echo e($req->vendor_name); ?>

                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex align-items-start gap-1 flex-shrink-1" style="min-width:0;">
                                    <span class="badge text-bg-light">
                                        <i class="fa fa-list me-1"></i> Lines: <?php echo e($req->lines_count); ?>

                                    </span>
                                    <span class="badge text-bg-light">
                                        <i class="fa fa-flag me-1"></i> Step: <?php echo e($req->current_step_no); ?>

                                    </span>
                                    <span class="badge text-bg-light">
                                        <i class="fa fa-calendar me-1"></i> Created:
                                        <?php echo e(\Illuminate\Support\Carbon::parse($req->created_at)->format('d M Y, H:i')); ?>

                                    </span>
                                    <?php if($req->updated_at): ?>
                                        <span class="badge text-bg-light">
                                            <i class="fa fa-clock me-1"></i>Modified By: <?php echo e($req->updated_by); ?> •
                                            <?php echo e(\Illuminate\Support\Carbon::parse($req->updated_at)->diffForHumans()); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- ✅ ARTICLE PREVIEW + VENDOR QUOTE -->
                            <?php if($req->lines->count() > 0): ?>
                                <?php $__currentLoopData = $req->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        // Ambil vendor_quotes
                                        $vq = $line->vendor_quotes;

                                        // Jika ternyata JSON string → decode ke array
                                        if (is_string($vq)) {
                                            $vq = json_decode($vq, true);
                                        }

                                        // Jika Collection → ubah ke array
                                        if ($vq instanceof \Illuminate\Support\Collection) {
                                            $vq = $vq->toArray();
                                        }

                                        // Jika array ada index ke-0 dan punya harga → pakai itu
                                        if (is_array($vq) && isset($vq[0]['price'])) {
                                            $price = $vq[0]['price'];
                                        } else {
                                            $price = 0;
                                        }
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                <div class="mt-2 d-flex align-items-center gap-2 flex-wrap">

                                    <!-- Artikel -->
                                    <span class="badge bg-light text-dark px-2 py-1" style="font-size: 13px;">
                                        <i class="fa fa-tag me-1"></i>
                                        <?php echo e($line->article_name); ?>

                                    </span>

                                    <!-- Vendor Quote Price -->
                                    <span class="badge bg-info text-dark px-2 py-1" style="font-size: 13px;">
                                        <i class="fa fa-money-bill me-1"></i>
                                        <?php echo e(number_format($price, 0)); ?>

                                    </span>

                                    <!-- More... jika lebih dari 1 line -->
                                    <?php if($req->lines->count() > 1): ?>
                                        <span class="text-muted" style="font-size:13px;">• more...</span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <!-- END PREVIEW -->

                            <div class="d-flex gap-3 align-items-center mt-2">
                                <div class="flex-fill align-items-end">
                                    <p class="mb-0 line-clamp-2 text-body-secondary">
                                        <?php echo e($req->remarks ?? 'No remarks'); ?>

                                    </p>
                                </div>

                                <div class="d-flex flex-column gap-2">
                                    <form class="d-flex gap-2 align-items-center" method="POST"
                                        action="<?php echo e(route('approvals.web.approve', $req->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <input type="text" name="comment" class="form-control form-control-sm"
                                            placeholder="Comment (optional)" onclick="event.stopPropagation()">
                                        <button type="submit" class="btn btn-success btn-sm"
                                            style="padding: 0.25rem 0.75rem; width: 130px; border-radius: 0.5rem; display: inline-flex; justify-content: center; align-items: center;"
                                            onclick="event.stopPropagation()">
                                            <i class="fa fa-thumbs-up me-1"></i> Approve
                                        </button>
                                    </form>

                                    <form class="d-flex gap-2 align-items-center" method="POST"
                                        action="<?php echo e(route('approvals.web.reject', $req->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <input type="text" name="comment" class="form-control form-control-sm"
                                            placeholder="Comment (optional)" onclick="event.stopPropagation()">
                                        <button type="submit" class="btn btn-danger btn-sm"
                                            style="padding: 0.25rem 0.75rem; width: 130px; border-radius: 0.5rem; display: inline-flex; justify-content: center; align-items: center;"
                                            onclick="event.stopPropagation()">
                                            <i class="fa fa-thumbs-down me-1"></i> Reject
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- View Button -->
                <a href="<?php echo e(route('approvals.show', $req->id)); ?>" class="badge-soft-secondary w-100 text-center"
                    style="border-radius: 0 0 1rem 1rem; padding: 0.5rem 0; font-weight: 500;">
                    <i class="fa fa-eye me-1"></i> View
                </a>
            </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-5">
                <div class="icon-circle mx-auto mb-3" style="width:64px;height:64px;">
                    <i class="fa fa-inbox fa-lg text-body-secondary"></i>
                </div>
                <h5 class="mb-1">No pending approvals</h5>
                <p class="text-body-secondary mb-3">You’re all caught up. New requests will appear here.</p>
                <?php if(Route::has('approvals.create')): ?>
                    <a href="<?php echo e(route('approvals.create')); ?>" class="btn btn-outline-primary">
                        <i class="fa fa-plus me-1"></i> Create New Request
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="d-flex justify-content-center mt-4">
            <?php echo e($items->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Lenovo\OneDrive\Documents\Kerjaan\stockopname\resources\views/approvals/inbox.blade.php ENDPATH**/ ?>