<?php
require_once '../config/connection.php';
require_once '../vendor/autoload.php';

use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;

header('Content-Type: application/json');

$panel_id = isset($_GET['panel_id']) ? (int)$_GET['panel_id'] : 0;

if ($panel_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid Panel ID']);
    exit;
}

try {
    $query = "
        SELECT 
            mcp.id,
            mcp.panel_code,
            mcp.rack_number,
            mcp.qr_code as panel_qr_code,
            mcp.manufacturing_date as panel_manufacturing_date,
            mcp.expired_date as panel_expired_date,
            mcp.created_at,
            mc.code_color as master_code,
            mc.color_name,
            mc.manufacturing_date as master_manufacturing_date,
            mc.expired_date as master_expired_date,
            mc.lemari,
            mc.lemari_number,
            b.nama_buyer,
            b.kode_buyer,
            c.nama_collection
        FROM master_color_panel mcp
        LEFT JOIN master_color mc ON mcp.master_color_id = mc.id
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        LEFT JOIN collections c ON mc.collection_id = c.id
        WHERE mcp.id = $panel_id
        LIMIT 1
    ";
    
    $result = $conn->query($query);
    
    if (!$result || $result->num_rows == 0) {
        echo json_encode(['success' => false, 'message' => 'Master Color Panel tidak ditemukan']);
        exit;
    }
    
    $row = $result->fetch_assoc();
    $panel_code = $row['panel_code'];
    
    // Create fresh QR instance
    $options = new QROptions([
        'version'    => 5,
        'outputType' => QRCode::OUTPUT_IMAGE_PNG,
        'eccLevel'   => QRCode::ECC_L,
        'scale'      => 10,
        'imageBase64' => true,
    ]);
    
    $qrcode = new QRCode($options);
    
    // Clean panel code sebelum generate
    $clean_panel_code = trim($panel_code);
    $qr_image = $qrcode->render($clean_panel_code);
    
    // Update manufacturing_date dan expired_date dari master jika panel belum memiliki
    $panel_mfg_date = $row['panel_manufacturing_date'];
    $panel_exp_date = $row['panel_expired_date'];
    
    if (empty($panel_mfg_date) && !empty($row['master_manufacturing_date'])) {
        $panel_mfg_date = $row['master_manufacturing_date'];
    }
    if (empty($panel_exp_date) && !empty($row['master_expired_date'])) {
        $panel_exp_date = $row['master_expired_date'];
    }
    
    // Update QR code dan dates ke database
    $qr_escaped = $conn->real_escape_string($qr_image);
    $update_query = "UPDATE master_color_panel SET 
                        qr_code = '$qr_escaped'";
    
    if (!empty($panel_mfg_date)) {
        $update_query .= ", manufacturing_date = '" . $conn->real_escape_string($panel_mfg_date) . "'";
    }
    if (!empty($panel_exp_date)) {
        $update_query .= ", expired_date = '" . $conn->real_escape_string($panel_exp_date) . "'";
    }
    
    $update_query .= " WHERE id = $panel_id";
    $conn->query($update_query);
    
    // Format tanggal untuk response
    $mfg_date = !empty($panel_mfg_date) ? date('d-m-Y', strtotime($panel_mfg_date)) : '-';
    $exp_date = !empty($panel_exp_date) ? date('d-m-Y', strtotime($panel_exp_date)) : '-';
    
    echo json_encode([
        'success' => true,
        'panel_code' => $panel_code,
        'master_code' => $row['master_code'],
        'color_name' => $row['color_name'],
        'buyer_name' => $row['nama_buyer'],
        'kode_buyer' => $row['kode_buyer'],
        'collection_name' => $row['nama_collection'],
        'manufacturing_date' => $mfg_date,
        'expired_date' => $exp_date,
        'rack_number' => $row['rack_number'],
        'lemari' => $row['lemari'],
        'lemari_number' => $row['lemari_number'],
        'qr_image' => $qr_image
    ]);
    
    // Clear memory
    unset($qrcode);
    unset($options);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>