<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'borrower') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Access denied']);
    exit();
}

include '../config/connection.php';

// Handle AJAX request untuk proses pengembalian
if (isset($_POST['ajax_return']) && $_POST['ajax_return'] == '1') {
    header('Content-Type: application/json');
    
    $transaction_item_id = isset($_POST['transaction_item_id']) ? (int)$_POST['transaction_item_id'] : 0;
    $code_color = isset($_POST['code_color']) ? trim($_POST['code_color']) : '';
    $borrower_id = $_SESSION['user_id'];
    
    try {
        // Step 1: Update transaction_items jadi returned
        $actual_return_date = date('Y-m-d H:i:s');
        $update_query = "UPDATE transaction_items SET borrow_status = 'returned', actual_return_date = '$actual_return_date' WHERE id = $transaction_item_id";
        $conn->query($update_query);
        
        // Step 2: Ambil info
        $info_query = "SELECT stock_item_id, transaction_id FROM transaction_items WHERE id = $transaction_item_id";
        $info_result = $conn->query($info_query);
        $info = $info_result->fetch_assoc();
        
        $stock_item_id = $info['stock_item_id'];
        $transaction_id = $info['transaction_id'];
        
        // Step 3: Update stock jadi finished
        $update_stock = "UPDATE color_stock_items SET status = 'finished' WHERE id = $stock_item_id";
        $conn->query($update_stock);
        
        // Step 4: Cek apakah semua item sudah returned
        $check_query = "SELECT COUNT(*) as total FROM transaction_items WHERE transaction_id = $transaction_id AND borrow_status = 'borrowed'";
        $check_result = $conn->query($check_query);
        $check_data = $check_result->fetch_assoc();
        
        if ($check_data['total'] == 0) {
            // Semua sudah dikembalikan -> ARCHIVE & HAPUS!
            
            // ========================================================
            // ARCHIVE PROCESS - Simpan ke peminjaman_selesai
            // ========================================================
            
            // Get transaction data
            $trans_query = "SELECT st.*, bu.nama_borrower, bu.nik
                           FROM stock_transactions st
                           LEFT JOIN borrower_users bu ON st.borrower_id = bu.id
                           WHERE st.id = $transaction_id";
            $trans_result = $conn->query($trans_query);
            $trans_data = $trans_result->fetch_assoc();
            
            // Get all items data
            $items_query = "SELECT ti.code_color, ti.borrow_date, ti.actual_return_date,
                                  mc.color_name, cc.component_name,
                                  csi.code_barang_lemari5, csi.lokasi_penyimpanan, csi.lemari_number
                           FROM transaction_items ti
                           LEFT JOIN color_stock_items csi ON ti.stock_item_id = csi.id
                           LEFT JOIN master_color mc ON csi.master_color_id = mc.id
                           LEFT JOIN color_components cc ON csi.component_id = cc.id
                           WHERE ti.transaction_id = $transaction_id";
            $items_result = $conn->query($items_query);
            
            $items_array = [];
            while ($item = $items_result->fetch_assoc()) {
                $items_array[] = [
                    'code_color' => $item['code_color'],
                    'color_name' => $item['color_name'] ?? '-',
                    'component_name' => $item['component_name'] ?? '-',
                    'code_barang_lemari5' => $item['code_barang_lemari5'] ?? '-',
                    'lokasi_penyimpanan' => $item['lokasi_penyimpanan'] ?? '-',
                    'lemari_number' => $item['lemari_number'] ?? '-',
                    'borrow_date' => $item['borrow_date'],
                    'actual_return_date' => $item['actual_return_date']
                ];
            }
            
            $items_json = $conn->real_escape_string(json_encode($items_array, JSON_PRETTY_PRINT));
            
            // Calculate total days
            $start_date = new DateTime($trans_data['transaction_date']);
            $end_date = new DateTime($actual_return_date);
            $total_days = $start_date->diff($end_date)->days;
            
            // Insert to peminjaman_selesai
            $archive_query = "INSERT INTO peminjaman_selesai 
                             (original_transaction_id, transaction_number, borrower_id, borrower_name, borrower_nik,
                              transaction_date, expected_return_date, actual_return_date, transaction_status,
                              transaction_notes, items_data, total_items, total_days_borrowed, archived_by)
                             VALUES (
                                 {$trans_data['id']},
                                 '{$trans_data['transaction_number']}',
                                 {$trans_data['borrower_id']},
                                 '{$trans_data['nama_borrower']}',
                                 '{$trans_data['nik']}',
                                 '{$trans_data['transaction_date']}',
                                 '{$trans_data['expected_return_date']}',
                                 '{$actual_return_date}',
                                 'returned',
                                 " . ($trans_data['notes'] ? "'{$trans_data['notes']}'" : "NULL") . ",
                                 '{$items_json}',
                                 " . count($items_array) . ",
                                 {$total_days},
                                 {$borrower_id}
                             )";
            $conn->query($archive_query);
            
            // ========================================================
            // DELETE PROCESS
            // ========================================================
            
            // DISABLE FK
            $conn->query("SET FOREIGN_KEY_CHECKS = 0");
            
            // Delete stock items
            $delete_stock_result = $conn->query("DELETE FROM color_stock_items WHERE id IN (SELECT stock_item_id FROM transaction_items WHERE transaction_id = $transaction_id)");
            $deleted_count = $conn->affected_rows;
            
            // Delete transaction items
            $conn->query("DELETE FROM transaction_items WHERE transaction_id = $transaction_id");
            
            // Delete stock transactions
            $conn->query("DELETE FROM stock_transactions WHERE id = $transaction_id");
            
            // ENABLE FK
            $conn->query("SET FOREIGN_KEY_CHECKS = 1");
            
            // Log to audit
            $log_details = $conn->real_escape_string("Archived & Deleted Transaction: {$trans_data['transaction_number']} - {$deleted_count} items removed from stock");
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $conn->query("INSERT INTO audit_logs (action_type, user_id, user_type, details, ip_address) 
                         VALUES ('ARCHIVE_COMPLETE_TRANSACTION', {$borrower_id}, 'borrower', '{$log_details}', '{$ip_address}')");
            
            $message = "✅ BERHASIL! Transaksi diarsipkan dan {$deleted_count} item DIHAPUS dari stock!";
        } else {
            $message = "✅ Item {$code_color} dikembalikan!";
        }
        
        echo json_encode([
            'success' => true,
            'message' => $message
        ]);
        
    } catch (Exception $e) {
        $conn->query("SET FOREIGN_KEY_CHECKS = 1");
        
        echo json_encode([
            'success' => false,
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
    
    exit();
}

header('Location: history_peminjaman.php');
exit();
?>