<?php
require_once '../config/connection.php';

header('Content-Type: application/json');

$panel_code = isset($_GET['panel_code']) ? $conn->real_escape_string($_GET['panel_code']) : '';

if (empty($panel_code)) {
    echo json_encode(['success' => false, 'message' => 'Panel code is required']);
    exit;
}

try {
    $query = "
        SELECT 
            mcp.panel_code,
            mcp.rack_number,
            mcp.qr_code as panel_qr_code,
            mcp.manufacturing_date as panel_manufacturing_date,
            mcp.expired_date as panel_expired_date,
            mcp.created_at,
            mc.code_color as master_code,
            mc.color_name,
            mc.manufacturing_date as master_manufacturing_date,
            mc.expired_date as master_expired_date,
            mc.lemari,
            mc.lemari_number,
            b.nama_buyer,
            b.kode_buyer,
            c.nama_collection
        FROM master_color_panel mcp
        LEFT JOIN master_color mc ON mcp.master_color_id = mc.id
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        LEFT JOIN collections c ON mc.collection_id = c.id
        WHERE mcp.panel_code = '$panel_code'
        LIMIT 1
    ";
    
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        
        if (!empty($row['panel_qr_code'])) {
            // Use panel dates if available, otherwise use master dates
            $mfg_date = !empty($row['panel_manufacturing_date']) ? $row['panel_manufacturing_date'] : $row['master_manufacturing_date'];
            $exp_date = !empty($row['panel_expired_date']) ? $row['panel_expired_date'] : $row['master_expired_date'];
            
            // Format tanggal
            $mfg_date_formatted = !empty($mfg_date) ? date('d-m-Y', strtotime($mfg_date)) : '-';
            $exp_date_formatted = !empty($exp_date) ? date('d-m-Y', strtotime($exp_date)) : '-';
            
            echo json_encode([
                'success' => true,
                'panel_code' => $row['panel_code'],
                'master_code' => $row['master_code'],
                'color_name' => $row['color_name'],
                'buyer_name' => $row['nama_buyer'],
                'kode_buyer' => $row['kode_buyer'],
                'collection_name' => $row['nama_collection'],
                'manufacturing_date' => $mfg_date_formatted,
                'expired_date' => $exp_date_formatted,
                'rack_number' => $row['rack_number'],
                'lemari' => $row['lemari'],
                'lemari_number' => $row['lemari_number'],
                'qr_image' => $row['panel_qr_code']
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'QR Code belum di-generate']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Master color panel not found']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>