<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in and has IT privileges
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$action = isset($_POST['action']) ? $_POST['action'] : '';

$conn->begin_transaction();

try {
    switch($action) {
        case 'reset_by_buyer':
            // Hapus data warna berdasarkan buyer
            // TIDAK menghapus: buyer itu sendiri, collections, users, components, wc_master
            
            $buyer_id = isset($_POST['buyer_id']) ? (int)$_POST['buyer_id'] : 0;
            
            if ($buyer_id <= 0) {
                throw new Exception('Buyer ID tidak valid');
            }
            
            // Get buyer info
            $query_buyer = "SELECT nama_buyer FROM buyers WHERE id = $buyer_id";
            $result_buyer = $conn->query($query_buyer);
            
            if ($result_buyer->num_rows == 0) {
                throw new Exception('Buyer tidak ditemukan');
            }
            
            $buyer_data = $result_buyer->fetch_assoc();
            $buyer_name = $buyer_data['nama_buyer'];
            
            // Get statistics before delete
            $query_count = "
                SELECT 
                    (SELECT COUNT(*) FROM master_color WHERE buyer_id = $buyer_id) as total_colors,
                    (SELECT COUNT(*) FROM master_color_panel WHERE buyer_id = $buyer_id) as total_panels,
                    (SELECT COUNT(*) FROM color_stock_items WHERE master_color_id IN (SELECT id FROM master_color WHERE buyer_id = $buyer_id)) as total_stocks,
                    (SELECT COUNT(*) FROM transaction_items WHERE stock_item_id IN (SELECT id FROM color_stock_items WHERE master_color_id IN (SELECT id FROM master_color WHERE buyer_id = $buyer_id))) as total_transactions
            ";
            $result_count = $conn->query($query_count);
            $counts = $result_count->fetch_assoc();
            
            // Delete transaction items first (foreign key constraint to color_stock_items)
            $delete_trans_items = "DELETE FROM transaction_items 
                                   WHERE stock_item_id IN (
                                       SELECT id FROM color_stock_items 
                                       WHERE master_color_id IN (
                                           SELECT id FROM master_color WHERE buyer_id = $buyer_id
                                       )
                                   )";
            if (!$conn->query($delete_trans_items)) {
                throw new Exception('Gagal menghapus transaction items: ' . $conn->error);
            }
            
            // Delete stock items
            $delete_stocks = "DELETE FROM color_stock_items 
                             WHERE master_color_id IN (
                                 SELECT id FROM master_color WHERE buyer_id = $buyer_id
                             )";
            if (!$conn->query($delete_stocks)) {
                throw new Exception('Gagal menghapus stock items: ' . $conn->error);
            }
            
            // Delete panels
            $delete_panels = "DELETE FROM master_color_panel WHERE buyer_id = $buyer_id";
            if (!$conn->query($delete_panels)) {
                throw new Exception('Gagal menghapus panels: ' . $conn->error);
            }
            
            // Delete master colors
            $delete_colors = "DELETE FROM master_color WHERE buyer_id = $buyer_id";
            if (!$conn->query($delete_colors)) {
                throw new Exception('Gagal menghapus master colors: ' . $conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('RESET_BY_BUYER', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $audit_details = "Reset data warna untuk buyer: $buyer_name (ID: $buyer_id) - Deleted: {$counts['total_colors']} colors, {$counts['total_panels']} panels, {$counts['total_stocks']} stock items, {$counts['total_transactions']} transaction items";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode([
                'success' => true,
                'message' => "Berhasil menghapus data warna untuk buyer: $buyer_name. Total dihapus: {$counts['total_colors']} colors, {$counts['total_panels']} panels, {$counts['total_stocks']} stock items, {$counts['total_transactions']} transaction items"
            ]);
            break;
            
        case 'reset_by_master_color':
            // Hapus satu master color beserta relasi-nya
            
            $master_color_id = isset($_POST['master_color_id']) ? (int)$_POST['master_color_id'] : 0;
            
            if ($master_color_id <= 0) {
                throw new Exception('Master Color ID tidak valid');
            }
            
            // Get master color info
            $query_color = "SELECT code_color, color_name FROM master_color WHERE id = $master_color_id";
            $result_color = $conn->query($query_color);
            
            if ($result_color->num_rows == 0) {
                throw new Exception('Master Color tidak ditemukan');
            }
            
            $color_data = $result_color->fetch_assoc();
            $code_color = $color_data['code_color'];
            $color_name = $color_data['color_name'];
            
            // Get statistics before delete
            $query_count = "
                SELECT 
                    (SELECT COUNT(*) FROM master_color_panel WHERE master_color_id = $master_color_id) as total_panels,
                    (SELECT COUNT(*) FROM color_stock_items WHERE master_color_id = $master_color_id) as total_stocks,
                    (SELECT COUNT(*) FROM transaction_items WHERE stock_item_id IN (SELECT id FROM color_stock_items WHERE master_color_id = $master_color_id)) as total_transactions
            ";
            $result_count = $conn->query($query_count);
            $counts = $result_count->fetch_assoc();
            
            // Delete transaction items first (foreign key constraint to color_stock_items)
            $delete_trans_items = "DELETE FROM transaction_items 
                                   WHERE stock_item_id IN (
                                       SELECT id FROM color_stock_items WHERE master_color_id = $master_color_id
                                   )";
            if (!$conn->query($delete_trans_items)) {
                throw new Exception('Gagal menghapus transaction items: ' . $conn->error);
            }
            
            // Delete stock items
            $delete_stocks = "DELETE FROM color_stock_items WHERE master_color_id = $master_color_id";
            if (!$conn->query($delete_stocks)) {
                throw new Exception('Gagal menghapus stock items: ' . $conn->error);
            }
            
            // Delete panels
            $delete_panels = "DELETE FROM master_color_panel WHERE master_color_id = $master_color_id";
            if (!$conn->query($delete_panels)) {
                throw new Exception('Gagal menghapus panels: ' . $conn->error);
            }
            
            // Delete master color
            $delete_color = "DELETE FROM master_color WHERE id = $master_color_id";
            if (!$conn->query($delete_color)) {
                throw new Exception('Gagal menghapus master color: ' . $conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('RESET_MASTER_COLOR', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $audit_details = "Reset master color: $code_color - $color_name (ID: $master_color_id) - Deleted: {$counts['total_panels']} panels, {$counts['total_stocks']} stock items, {$counts['total_transactions']} transaction items";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode([
                'success' => true,
                'message' => "Berhasil menghapus master color: $code_color - $color_name. Total dihapus: {$counts['total_panels']} panels, {$counts['total_stocks']} stock items, {$counts['total_transactions']} transaction items"
            ]);
            break;
            
        case 'reset_all_data':
            // Hapus SEMUA data warna
            // TIDAK menghapus: buyers, users, components, collections, wc_master
            
            // Get statistics before delete
            $query_count = "
                SELECT 
                    (SELECT COUNT(*) FROM master_color) as total_colors,
                    (SELECT COUNT(*) FROM master_color_panel) as total_panels,
                    (SELECT COUNT(*) FROM color_stock_items) as total_stocks,
                    (SELECT COUNT(*) FROM transaction_items WHERE stock_item_id IN (SELECT id FROM color_stock_items)) as total_transactions
            ";
            $result_count = $conn->query($query_count);
            $counts = $result_count->fetch_assoc();
            
            // Delete all transaction items first (foreign key constraint to color_stock_items)
            $delete_trans_items = "DELETE FROM transaction_items 
                                   WHERE stock_item_id IN (SELECT id FROM color_stock_items)";
            if (!$conn->query($delete_trans_items)) {
                throw new Exception('Gagal menghapus transaction items: ' . $conn->error);
            }
            
            // Delete all stock items
            $delete_stocks = "DELETE FROM color_stock_items";
            if (!$conn->query($delete_stocks)) {
                throw new Exception('Gagal menghapus stock items: ' . $conn->error);
            }
            
            // Delete all panels
            $delete_panels = "DELETE FROM master_color_panel";
            if (!$conn->query($delete_panels)) {
                throw new Exception('Gagal menghapus panels: ' . $conn->error);
            }
            
            // Delete all master colors
            $delete_colors = "DELETE FROM master_color";
            if (!$conn->query($delete_colors)) {
                throw new Exception('Gagal menghapus master colors: ' . $conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('RESET_ALL_COLOR_DATA', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $audit_details = "RESET ALL COLOR DATA - Deleted: {$counts['total_colors']} colors, {$counts['total_panels']} panels, {$counts['total_stocks']} stock items, {$counts['total_transactions']} transaction items. Safe data (buyers, users, components, collections, wc_master) NOT deleted.";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode([
                'success' => true,
                'message' => "SEMUA data warna berhasil dihapus! Total: {$counts['total_colors']} colors, {$counts['total_panels']} panels, {$counts['total_stocks']} stock items, {$counts['total_transactions']} transaction items. Data Buyers, Users, Components, Collections, dan WC Master tetap aman."
            ]);
            break;
            
        default:
            throw new Exception('Action tidak valid');
            break;
    }
    
} catch(Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>